# frozen_string_literal: true

module Wpxf
  module Models
    # A workspace with isolated loot and credentials.
    class Workspace < Sequel::Model
      plugin :validation_helpers

      one_to_many :credentials
      one_to_many :loot_items

      def validate
        super

        validates_presence :name
        validates_type String, :name
        validates_unique :name
        validates_format /^[A-Za-z0-9_]{1,50}$/, :name
      end

      def before_destroy
        super
        credentials.each(&:destroy)
        loot_items.each(&:destroy)
      end
    end
  end
end
