# frozen_string_literal: true

module Wpxf
  # A string option.
  class StringOption < Option
    # @param value the value to normalize. If a string starting with
    #   "file:" is specified, the path following it will be used to populate
    #   the value from the contents of the file.
    # @return [String] a normalized value to conform with the type that
    #   the option is conveying.
    def normalize(value)
      match = value&.match(/^file:(.*)/)
      if match
        path = match[1]
        begin
          value = File.read(path)
        rescue ::Errno::ENOENT, ::Errno::EISDIR
          value = nil
        end
      end

      value
    end

    # Check if the specified value is valid in the context of this option.
    # @param value the value to validate.
    # @return [Boolean] true if valid.
    def valid?(value)
      value = normalize(value)
      super(value)
    end
  end
end
