# frozen_string_literal: true

require 'wpxf/modules'

module Wpxf
  module Cli
    # A helper class for printing banners in the terminal.
    class Banner
      def initialize
        file = Wpxf::DataFile.new('banners', 'default.txt')
        self.raw_content = file.content
      end

      def format_colour(value)
        value.gsub('{WB}', "\e[0m\e[97m\e[1m")
             .gsub('{WN}', "\e[0m\e[97m")
             .gsub('{GN}', "\e[0m\e[32m")
             .gsub('{LGN}', "\e[0m\e[37m")
             .gsub('{YB}', "\e[0m\e[33m\e[1m")
      end

      def auxiliary_count
        Wpxf::Models::Module.where(type: 'auxiliary').count
      end

      def exploit_count
        Wpxf::Models::Module.where(type: 'exploit').count
      end

      def format_data(value)
        value.gsub('{VERSION}', Wpxf.version)
             .gsub('{AUXILIARY_COUNT}', auxiliary_count.to_s)
             .gsub('{EXPLOIT_COUNT}', exploit_count.to_s)
             .gsub('{PAYLOAD_COUNT}', Wpxf::Payloads.payload_count.to_s)
      end

      def display
        formatted = format_colour(raw_content)
        formatted = format_data(formatted)
        puts formatted
        puts
      end

      attr_accessor :raw_content
    end
  end
end
