/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;
import net.seleucus.wsp.util.WSUtil;

public class WSPassPhraseShow
extends WSCommandOption {
    public WSPassPhraseShow(WSServer myServer) {
        super(myServer);
    }

    @Override
    protected void execute() {
        String users = this.myServer.getWSDatabase().users.showUsers();
        this.myServer.println(users);
        int ppID = this.myServer.readLineOptionalInt("Select a User ID");
        boolean userIDFound = this.myServer.getWSDatabase().passPhrases.isPPIDInUse(ppID);
        if (!userIDFound) {
            this.myServer.println("User ID Not Found");
        } else {
            String userName = this.myServer.getWSDatabase().users.getUsersFullName(ppID);
            String choice = this.myServer.readLineOptional("Show pass-phrase [y/N]");
            if (WSUtil.isAnswerPositive(choice)) {
                CharSequence passSeq = this.myServer.getWSDatabase().passPhrases.getPassPhrase(ppID);
                String lastModifiedDate = this.myServer.getWSDatabase().passPhrases.getLastModifiedDate(ppID);
                this.myServer.println("");
                this.myServer.println("ID: " + ppID);
                this.myServer.println("Full Name: " + userName);
                this.myServer.println("Pass-Phrase: " + passSeq.toString());
                this.myServer.println("Last Modified: " + lastModifiedDate);
                this.myServer.println("");
            }
        }
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        boolean valid = false;
        if (cmd.equalsIgnoreCase("pass-phrase show")) {
            valid = true;
        }
        return valid;
    }
}

