/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server;

import java.io.File;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.seleucus.wsp.config.WSConfiguration;
import net.seleucus.wsp.db.WSDatabase;
import net.seleucus.wsp.main.WSGestalt;
import net.seleucus.wsp.main.WSVersion;
import net.seleucus.wsp.main.WebSpa;
import net.seleucus.wsp.server.WSAction;
import net.seleucus.wsp.server.WSLogListener;
import net.seleucus.wsp.server.WSServerConsole;
import org.apache.commons.io.input.Tailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSServer
extends WSGestalt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSServer.class);
    private Tailer myLogTailer = null;
    private ExecutorService myExecService = Executors.newSingleThreadExecutor();
    private boolean serviceStarted = false;
    private WSDatabase myDatabase = new WSDatabase();
    private WSLogListener myLogListener;
    private WSConfiguration myConfiguration = new WSConfiguration();
    private WSServerConsole myServerCommand;

    public WSServer(WebSpa myWebSpa) throws Exception {
        super(myWebSpa);
        this.myLogListener = new WSLogListener(this);
        this.myServerCommand = new WSServerConsole(this);
    }

    public void serverStart() {
        if (this.serviceStarted) {
            LOGGER.info("Service is already running");
        } else {
            LOGGER.info("Attempting to start WebSpa...");
            File accessLog = new File(this.myConfiguration.getAccesLogFileLocation());
            if (accessLog.exists()) {
                LOGGER.info("Found access log file: " + accessLog.getPath());
                this.serviceStarted = true;
                if (this.myLogTailer == null) {
                    LOGGER.info("Creating tail listener...");
                    this.myLogTailer = Tailer.create(accessLog, this.myLogListener, 10000L, true);
                }
                LOGGER.info("WebSpa server started!");
                LOGGER.info("Please make sure your web server is also up");
            } else {
                LOGGER.error("Access log file NOT found at: " + accessLog.getPath());
                LOGGER.error("WebSpa Server Not Started");
            }
        }
    }

    public void serverStatus() {
        if (this.serviceStarted) {
            LOGGER.info("WebSpa is Running!");
        } else {
            LOGGER.info("WebSpa is Stopped.");
        }
    }

    public void serverStop() {
        if (this.myLogTailer == null) {
            LOGGER.info("WebSpa Server Had Not Started");
        } else {
            LOGGER.info("WebSpa Server Stopped");
            this.myLogTailer.stop();
            this.myLogTailer = null;
            this.serviceStarted = false;
        }
    }

    @Override
    public void exitConsole() {
        LOGGER.info("Goodbye!");
    }

    public void runOSCommand(int ppID, int actionNumber, String ipAddress) {
        WSAction action = new WSAction(this, ppID, actionNumber, ipAddress);
        this.myExecService.submit(action);
    }

    @Override
    public void runConsole() throws SQLException {
        LOGGER.info("");
        LOGGER.info("WebSpa - Single HTTP/S Request Authorisation");
        LOGGER.info("version " + WSVersion.getValue() + " (WebSpa@seleucus.net)");
        LOGGER.info("");
        LOGGER.info("This is a holding prompt, type \"exit\" or \"x\" to quit");
        LOGGER.info("");
        LOGGER.info("Type \"service start\" to start the WebSpa server");
        LOGGER.info("Type \"help\" or \"?\" for more options");
        LOGGER.info("");
        while (true) {
            String command;
            if ("laterz".equalsIgnoreCase(command = this.readLineServerPrompt()) || "exit".equalsIgnoreCase(command) || "quit".equalsIgnoreCase(command) || "bye".equalsIgnoreCase(command) || "x".equalsIgnoreCase(command)) break;
            this.processCommand(command);
        }
        this.shutdown();
    }

    public WSConfiguration getWSConfiguration() {
        return this.myConfiguration;
    }

    public WSDatabase getWSDatabase() {
        return this.myDatabase;
    }

    public void shutdown() throws SQLException {
        if (this.serviceStarted) {
            this.serverStop();
        }
        this.myDatabase.shutdown();
    }

    public void processCommand(String command) {
        this.myServerCommand.executeCommand(command.trim());
    }

    public void println(String msg) {
        this.myConsole.println(msg);
    }
}

