/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.main;

import java.nio.CharBuffer;
import java.sql.SQLException;
import java.util.Arrays;
import net.seleucus.wsp.console.WSConsole;
import net.seleucus.wsp.main.WebSpa;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WSGestalt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSGestalt.class);
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_PURPLE = "\u001b[35m";
    private static final String ANSI_RESET = "\u001b[0m";
    protected WSConsole myConsole;

    public WSGestalt(WebSpa myWebSpa) {
        this.myConsole = myWebSpa.getConsole();
    }

    public String readLineOptional(String displayString) {
        StringBuilder displayBuilder = new StringBuilder();
        displayBuilder.append("[Input Option] ");
        displayBuilder.append(displayString);
        displayBuilder.append(':');
        displayBuilder.append(' ');
        return this.myConsole.readLine("\u001b[34m USER [xx.xxx] " + displayBuilder.toString() + ANSI_RESET);
    }

    public int readLineOptionalInt(String displayString) {
        String inputString = this.readLineOptional(displayString);
        int output = -1;
        try {
            output = Integer.parseInt(inputString);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Invalid Number");
        }
        return output;
    }

    public String readLineRequired(String displayString) {
        String outputString;
        StringBuilder displayBuilder = new StringBuilder();
        displayBuilder.append("[Input Required] ");
        displayBuilder.append(displayString);
        displayBuilder.append(':');
        displayBuilder.append(' ');
        do {
            if (!(outputString = this.myConsole.readLine("\u001b[34m USER [xx.xxx] " + displayBuilder.toString() + ANSI_RESET).trim()).isEmpty()) continue;
            LOGGER.error("Your Input Cannot Be Blank");
        } while (outputString.isEmpty());
        return outputString;
    }

    public int readLineRequiredInt(String displayString, int minInclusiveValue, int maxInclusiveValue) {
        StringBuilder displayBuilder = new StringBuilder();
        displayBuilder.append(displayString);
        displayBuilder.append(" [");
        displayBuilder.append(minInclusiveValue);
        displayBuilder.append(',');
        displayBuilder.append(maxInclusiveValue);
        displayBuilder.append(']');
        int output = -1;
        do {
            String inputString = this.readLineRequired(displayBuilder.toString());
            try {
                output = Integer.parseInt(inputString);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Invalid Number Format");
            }
        } while (output < minInclusiveValue || output > maxInclusiveValue);
        return output;
    }

    public String readLineServerPrompt() {
        return this.myConsole.readLine("\u001b[35mwebspa-server> \u001b[0m");
    }

    public CharSequence readPasswordRequired(String displayString) {
        char[] passCharArrayOne;
        StringBuilder displayBuilder = new StringBuilder();
        displayBuilder.append("[Input Required] ");
        displayBuilder.append(displayString);
        displayBuilder.append(':');
        displayBuilder.append(' ');
        boolean passPhrasesMatch = false;
        do {
            char[] passCharArrayTwo;
            if (!(passPhrasesMatch = Arrays.equals(passCharArrayOne = this.myConsole.readPassword("\u001b[35m PASS [xx.xxx] " + displayBuilder.toString() + ANSI_RESET), passCharArrayTwo = this.myConsole.readPassword("\u001b[35m PASS [xx.xxx] [Input Required] Re-enter the above value: \u001b[0m")))) {
                LOGGER.info("The Pass-Phrases Entered do not Match");
                LOGGER.info("Please try again");
                continue;
            }
            if (passCharArrayOne.length > 0) continue;
            LOGGER.error("\u001b[31mThe Pass-Phrase Cannot Be Blank\u001b[0m");
        } while (passCharArrayOne.length <= 0 || !passPhrasesMatch);
        return CharBuffer.wrap(passCharArrayOne);
    }

    public abstract void exitConsole();

    public abstract void runConsole() throws SQLException;
}

