/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class WSConfiguration {
    protected static final String CONFIG_PATH = "webspa-config.properties";
    private Properties configProperties;

    public WSConfiguration() throws IOException {
        File configFile = new File(CONFIG_PATH);
        if (!configFile.exists()) {
            URL bundledConfigLocation = ClassLoader.getSystemResource("config/bundled-webspa-config.properties");
            FileUtils.copyURLToFile(bundledConfigLocation, configFile);
        }
        FileInputStream in = new FileInputStream(configFile);
        this.configProperties = new Properties();
        this.configProperties.load(in);
        in.close();
    }

    public String getAccesLogFileLocation() {
        return this.configProperties.getProperty("access-log-file-location");
    }

    public String getLoginRegexForEachRequest() {
        return this.configProperties.getProperty("logging-regex-for-each-request");
    }
}

