## vt collection

Get information about collections

### Synopsis

Get information about one or more collections.

This command receives one or more collection IDs and returns information about
them. The information for each collection is returned in the same order as the
collections are passed to the command.

If the command receives a single hypen (-) the collection will be read from
the standard input, one per line.

```
vt collection [collection]... [flags]
```

### Examples

```
  vt collection malpedia_win_emotet
  vt collection malpedia_win_emotet alienvault_603eb1abdd4812819c64e197
  cat list_of_collections | vt collection -n [collection_name] -d [collection_description] -
```

### Options

```
  -x, --exclude strings    exclude fields matching the provided pattern
  -h, --help               help for collection
  -I, --identifiers-only   print identifiers only
  -i, --include strings    include fields matching the provided pattern (default [**])
  -t, --threads int        number of threads working in parallel (default 5)
```

### Options inherited from parent commands

```
  -k, --apikey string   API key
      --proxy string    HTTP proxy
  -v, --verbose         verbose output
```

### SEE ALSO

* [vt](vt.md)	 - A command-line tool for interacting with VirusTotal
* [vt collection attack_techniques](vt_collection_attack_techniques.md)	 - Collection's ATT&CK techniques.
* [vt collection autogenerated_graphs](vt_collection_autogenerated_graphs.md)	 - Autogenerated graphs related to the collection.
* [vt collection comments](vt_collection_comments.md)	 - Comments for the collection.
* [vt collection create](vt_collection_create.md)	 - Create a collection.
* [vt collection delete](vt_collection_delete.md)	 - Delete a collection.
* [vt collection domains](vt_collection_domains.md)	 - Collection's domains.
* [vt collection files](vt_collection_files.md)	 - Collection's files.
* [vt collection ip_addresses](vt_collection_ip_addresses.md)	 - Collection's IP addresses.
* [vt collection owner](vt_collection_owner.md)	 - User who created the collection.
* [vt collection references](vt_collection_references.md)	 - Collection's references.
* [vt collection relationships](vt_collection_relationships.md)	 - Get all relationships.
* [vt collection remove](vt_collection_remove.md)	 - Remove items from a collection.
* [vt collection rename](vt_collection_rename.md)	 - Rename collection.
* [vt collection sigma_rules](vt_collection_sigma_rules.md)	 - Collection's SIGMA rules.
* [vt collection stats](vt_collection_stats.md)	 - Monthly lookup and submission stats per country.
* [vt collection subscribed_users](vt_collection_subscribed_users.md)	 - Users subscribed to the collection.
* [vt collection subscription_preferences](vt_collection_subscription_preferences.md)	 - Subscription preference for the given user.
* [vt collection threat_actors](vt_collection_threat_actors.md)	 - Collection's threat actors.
* [vt collection update](vt_collection_update.md)	 - Add new items to a collection.
* [vt collection urls](vt_collection_urls.md)	 - Collection's URLs.
* [vt collection yara_rulesets](vt_collection_yara_rulesets.md)	 - Collection's YARA rulesets.

