# encoding: UTF-8

require 'vulnerability/output'
require 'vulnerability/urls'

class Vulnerability
  include Vulnerability::Output
  include Vulnerability::Urls

  attr_accessor :title, :references, :type, :fixed_in, :cvss

  #
  # @param [ String ] title The title of the vulnerability
  # @param [ String ] type  The type of the vulnerability
  # @param [ Hash ] references References
  # @param [ String ] fixed_in  Vuln fixed in Version X
  #
  # @return [ Vulnerability ]
  def initialize(title, type, references = {}, fixed_in = '', cvss = '')
    @title              = title
    @type               = type
    @references         = references
    @fixed_in           = fixed_in
    @cvss               = cvss
  end

  # @param [ Vulnerability ] other
  #
  # @return [ Boolean ]
  # :nocov:
  def ==(other)
    title == other.title &&
        type == other.type &&
        references == other.references &&
        fixed_in == other.fixed_in
  end
  # :nocov:

  # Create the Vulnerability from the json_item
  #
  # @param [ Hash ] json_item
  #
  # @return [ Vulnerability ]
  def self.load_from_json_item(json_item)
    references = {}

    %w(url cve secunia osvdb metasploit exploitdb wpvulndb).each do |key|
      if json_item[key]
        json_item[key]  = [json_item[key]] if json_item[key].class != Array
        references[key] = json_item[key]
      end
    end

    new(
      json_item['title'],
      json_item['type'],
      references,
      json_item['fixed_in'],
      json_item['cvss'],
    )
  end

end
