/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFImage;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFStream;
import gnu.jpdf.PDFStringHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;

public class PDFGraphics
extends Graphics2D
implements Serializable {
    private static final double degrees_to_radians = Math.PI / 180;
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final Stroke DEF_STROKE = new BasicStroke();
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private static Map<Image, PDFImage> usedImages = new WeakHashMap<Image, PDFImage>();
    private Color background;
    private boolean child;
    private Area clip;
    protected Rectangle clipRectangle;
    private Composite composite;
    private Graphics2D dg2 = new BufferedImage(2, 2, 1).createGraphics();
    private Font font;
    private boolean inStroke;
    private boolean inText;
    private int lineCap = 0;
    private int lineJoin = 0;
    private float lineWidth = 1.0f;
    private float lx;
    private float ly;
    private float miterLimit = 10.0f;
    private boolean newFont;
    private Stroke originalStroke;
    private AffineTransform oTransform;
    private PDFPage page;
    private Paint paint;
    private PDFFont pdffont;
    private String pre_np;
    private AffineTransform pTransform;
    private PrintWriter pw;
    private RenderingHints rhints = new RenderingHints(null);
    private Stroke stroke;
    private AffineTransform transform;
    protected float trax;
    protected float tray;
    private float tx;
    private float ty;

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.rhints.putAll(hints);
    }

    public void arc(double axc, double ayc, double width, double height, double ang1, double ang2, boolean clockwise) {
        double w;
        double adiff;
        boolean first = true;
        double ang1r = ang1 % 360.0 * (Math.PI / 180);
        double sin0 = Math.sin(ang1r);
        double cos0 = Math.cos(ang1r);
        double x0 = axc + width * cos0;
        double y0 = ayc + height * sin0;
        if (!clockwise) {
            while (ang1 < ang2) {
                ang2 -= 360.0;
            }
            while (true) {
                double d;
                adiff = ang2 - ang1;
                if (d < -90.0) {
                    w = sin0;
                    sin0 = -cos0;
                    cos0 = w;
                    double x3r = axc + width * cos0;
                    double y3r = ayc + height * sin0;
                    this.arc_add(first, width, height, x0, y0, x3r, y3r, x0 + width * cos0, y0 + height * sin0);
                    x0 = x3r;
                    y0 = y3r;
                    ang1 -= 90.0;
                    first = false;
                    continue;
                }
                break;
            }
        } else {
            while (ang2 < ang1) {
                ang2 += 360.0;
            }
            while (true) {
                double d;
                adiff = ang2 - ang1;
                if (!(d > 90.0)) break;
                w = cos0;
                cos0 = -sin0;
                sin0 = w;
                double x3r = axc + width * cos0;
                double y3r = ayc + height * sin0;
                this.arc_add(first, width, height, x0, y0, x3r, y3r, x0 + width * cos0, y0 + height * sin0);
                x0 = x3r;
                y0 = y3r;
                ang1 += 90.0;
                first = false;
            }
        }
        double trad = Math.tan(adiff * (Math.PI / 360));
        double ang2r = ang2 * (Math.PI / 180);
        double xt = x0 - trad * width * sin0;
        double yt = y0 + trad * height * cos0;
        this.arc_add(first, width, height, x0, y0, axc + width * Math.cos(ang2r), ayc + height * Math.sin(ang2r), xt, yt);
    }

    private void arc_add(boolean first, double w, double h, double x0, double y0, double x3, double y3, double xt, double yt) {
        double dx = xt - x0;
        double dy = yt - y0;
        double dist = dx * dx + dy * dy;
        double w2 = w * w;
        double h2 = h * h;
        double r2 = w2 + h2;
        double fw = 0.0;
        double fh = 0.0;
        if (dist < r2 * 1.0E8) {
            fw = w2 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + dist / w2)) : 0.0;
            double d = fh = h2 != 0.0 ? 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + dist / h2)) : 0.0;
        }
        if (first) {
            this.moveto(x0, y0);
        }
        double x = x0 + (xt - x0) * fw;
        double y = y0 + (yt - y0) * fh;
        x0 = x3 + (xt - x3) * fw;
        y0 = y3 + (yt - y3) * fh;
        this.curveto(x, y, x0, y0, x3, y3);
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        this.closeBlock();
        this.pw.print("q 1 1 1 RG ");
        this.drawRect(x, y, w, h);
        this.closeBlock("B Q");
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.setClip(null);
            return;
        }
        s = this.transform.createTransformedShape(s);
        if (this.clip == null) {
            this.clip = new Area(s);
        } else {
            this.clip.intersect(new Area(s));
        }
    }

    public void clipPolygon(Polygon p) {
        this.closeBlock();
        this.polygon(p.xpoints, p.ypoints, p.npoints);
        this.closeBlock("W");
        this.clipRectangle = p.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.setClip(x, y, w, h);
    }

    void closeBlock() {
        this.closeBlock("S");
    }

    void closeBlock(String code) {
        if (this.inText) {
            this.pw.println("ET Q");
        }
        if (this.inStroke) {
            this.pw.println(code);
        }
        this.inText = false;
        this.inStroke = false;
    }

    @Override
    public void copyArea(int x, int y, int w, int h, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        this.closeBlock();
        PDFGraphics g = this.createGraphic(this.page, this.pw);
        g.trax = this.trax;
        g.tray = this.tray;
        g.clipRectangle = new Rectangle(this.clipRectangle);
        return g;
    }

    protected PDFGraphics createGraphic(PDFPage page, PrintWriter pw) {
        PDFGraphics g = new PDFGraphics();
        g.init(page, pw);
        return g;
    }

    public void curveto(double x1, double y1, double x2, double y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "v");
        this.lx = (float)x2;
        this.ly = (float)y2;
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + this.cxy(x3, y3) + "c");
        this.lx = (float)x3;
        this.ly = (float)y3;
    }

    public void curveto(int x1, int y1, int x2, int y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "v");
        this.lx = x2;
        this.ly = y2;
    }

    public void curveto(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + this.cxy(x3, y3) + "c");
        this.lx = x3;
        this.ly = y3;
    }

    public void curveto2(double x1, double y1, double x2, double y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "y");
        this.lx = (float)x2;
        this.ly = (float)y2;
    }

    public void curveto2(int x1, int y1, int x2, int y2) {
        this.newPath();
        this.pw.println(this.cxy(x1, y1) + this.cxy(x2, y2) + "y");
        this.lx = x2;
        this.ly = y2;
    }

    private String cwh(double w, double h) {
        double nw = w;
        double nh = h;
        nh = -h;
        return "" + df.format(nw) + " " + df.format(nh) + " ";
    }

    private String cwh(int w, int h) {
        return this.cwh((double)w, (double)h);
    }

    private String cxy(double x, double y) {
        Point2D.Double ptSrc = new Point2D.Double(x, y);
        Point2D.Double ptDst = new Point2D.Double();
        this.transform.transform(ptSrc, ptDst);
        return "" + df.format(((Point2D)ptDst).getX()) + " " + df.format(((Point2D)ptDst).getY()) + " ";
    }

    private String cxy(int x, int y) {
        return this.cxy((double)x, (double)y);
    }

    @Override
    public void dispose() {
        this.closeBlock();
        if (this.child) {
            this.pw.println("Q");
        } else {
            this.pw.close();
        }
    }

    @Override
    public void draw(Shape s) {
        this.followPath(s, 2);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
    }

    @Override
    public void drawArc(int x, int y, int w, int h, int sa, int aa) {
        this.arc(x += (w >>= 1), y += (h >>= 1), w, h, -sa, -sa - aa, false);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape s = g.getOutline(x, y);
        this.fill(s);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage result = img;
        if (op != null) {
            result = op.createCompatibleDestImage(img, img.getColorModel());
            result = op.filter(img, result);
        }
        this.drawImage((Image)result, x, y, null);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver obs) {
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), bgcolor, obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver obs) {
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver obs) {
        this.closeBlock();
        this.pw.print("q ");
        Color c = this.getColor();
        this.setColor(bgcolor);
        this.drawRect(x, y, w, h);
        this.closeBlock("B Q");
        this.paint = c;
        return this.drawImage(img, x, y, img.getWidth(obs), img.getHeight(obs), obs);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver obs) {
        PDFImage image;
        this.closeBlock();
        if (usedImages.containsKey(img)) {
            image = usedImages.get(img);
        } else {
            image = new PDFImage(img, obs);
            this.page.getPDFDocument().setImageName(image);
            this.page.getPDFDocument().add(image);
            usedImages.put(img, image);
        }
        this.page.addToProcset("/ImageC");
        this.page.addImageResource(image.getName() + " " + image.getSerialID() + " 0 R");
        this.pw.print("q " + w + " 0 0 " + h + " " + x + " " + ((int)this.page.getDimension().getHeight() - y - h) + " cm \n" + image.getName() + " Do\nQ\n");
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver obs) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.moveto(x1, y1);
        this.lineto(x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        this.drawArc(x, y, w, h, 0, 360);
    }

    @Override
    public void drawPolygon(int[] xp, int[] yp, int np) {
        this.polygon(xp, yp, np);
        this.closeBlock("s");
    }

    @Override
    public void drawPolyline(int[] xp, int[] yp, int np) {
        this.polygon(xp, yp, np);
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        this.newPath();
        this.pw.print(this.cxy(x, y) + this.cwh(w, h) + "re ");
        this.lx = x;
        this.ly = y;
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage image = null;
        if (img instanceof BufferedImage) {
            image = (BufferedImage)img;
        } else {
            ColorModel cm = img.getColorModel();
            int width = img.getWidth();
            int height = img.getHeight();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = img.getPropertyNames();
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    properties.put(keys[i], img.getProperty(keys[i]));
                }
            }
            BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            img.copyData(raster);
            image = result;
        }
        this.drawImage(image, xform, null);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int aw, int ah) {
    }

    @Override
    public void drawString(AttributedCharacterIterator aci, float x, float y) {
    }

    @Override
    public void drawString(AttributedCharacterIterator aci, int x, int y) {
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.newTextBlock(x, y);
        this.pw.println(PDFStringHelper.makePDFString(s) + " Tj");
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.newTextBlock(x, y);
        this.pw.println(PDFStringHelper.makePDFString(s) + " Tj");
    }

    @Override
    public void fill(Shape s) {
        this.followPath(s, 1);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
    }

    @Override
    public void fillArc(int x, int y, int w, int h, int sa, int aa) {
        this.closeBlock();
        this.drawArc(x, y, w, h, sa, aa);
        this.lineto(x + (w >> 1), y + (h >> 1));
        this.closeBlock("b");
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        this.fillArc(x, y, w, h, 0, 360);
    }

    @Override
    public void fillPolygon(int[] xp, int[] yp, int np) {
        this.closeBlock();
        this.polygon(xp, yp, np);
        this.closeBlock("b");
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.closeBlock();
        this.drawRect(x, y, w, h);
        this.closeBlock("B");
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int aw, int ah) {
    }

    private void followPath(Shape s, int drawType) {
        if (s == null) {
            return;
        }
        if (drawType == 2 && !(this.stroke instanceof BasicStroke)) {
            s = this.stroke.createStrokedShape(s);
            this.followPath(s, 1);
            return;
        }
        PathIterator points = s.getPathIterator(IDENTITY);
        int segments = 0;
        float[] coords = new float[6];
        while (!points.isDone()) {
            ++segments;
            int segtype = points.currentSegment(coords);
            switch (segtype) {
                case 4: {
                    this.pw.print("h ");
                    break;
                }
                case 3: {
                    this.curveto(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    this.lineto(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    this.moveto(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.curveto(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            points.next();
        }
        switch (drawType) {
            case 1: {
                if (segments <= 0) break;
                if (points.getWindingRule() == 0) {
                    this.closeBlock("B*");
                    break;
                }
                this.closeBlock("B");
                break;
            }
            case 2: {
                if (segments <= 0) break;
                this.closeBlock("S");
                break;
            }
            default: {
                if (segments == 0) {
                    this.drawRect(0, 0, 0, 0);
                }
                if (points.getWindingRule() == 0) {
                    this.closeBlock("W*");
                    break;
                }
                this.closeBlock("W");
            }
        }
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clipRectangle;
    }

    @Override
    public Color getColor() {
        return this.paint instanceof Color ? (Color)this.paint : Color.black;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.dg2.getDeviceConfiguration();
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("SansSerif", 0, 12));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        Frame dummy = new Frame();
        dummy.addNotify();
        Image image = dummy.createImage(100, 100);
        if (image == null) {
            System.err.println("getFontMetrics: image is null");
        }
        Graphics graphics = image.getGraphics();
        return graphics.getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean antialias = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean fractions = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), antialias, fractions);
    }

    public PDFPage getPage() {
        return this.page;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key arg0) {
        return this.rhints.get(arg0);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.rhints;
    }

    @Override
    public Stroke getStroke() {
        return this.originalStroke;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.oTransform);
    }

    public PrintWriter getWriter() {
        return this.pw;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.stroke.createStrokedShape(s);
        }
        s = this.transform.createTransformedShape(s);
        Area area = new Area(s);
        if (this.clip != null) {
            area.intersect(this.clip);
        }
        return area.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    private void init() {
        PageFormat pf = this.page.getPageFormat();
        if (this.child) {
            this.pw.print("q ");
        }
        this.paint = Color.black;
        this.oTransform = new AffineTransform();
        this.pTransform = new AffineTransform();
        this.pTransform.translate(0.0, pf.getHeight());
        this.pTransform.scale(1.0, -1.0);
        this.transform = new AffineTransform(this.oTransform);
        this.transform.concatenate(this.pTransform);
        this.setStroke(DEF_STROKE);
    }

    protected void init(PDFPage page) {
        this.page = page;
        this.child = false;
        PDFStream stream = new PDFStream();
        stream.setDeflate(true);
        page.getPDFDocument().add(stream);
        page.add(stream);
        this.pw = stream.getWriter();
        this.clipRectangle = page.getImageableArea();
        this.init();
    }

    protected void init(PDFPage page, PrintWriter pw) {
        this.page = page;
        this.pw = pw;
        this.child = true;
        this.init();
    }

    public void lineto(double x, double y) {
        this.newPath();
        this.pw.print(this.cxy(x, y) + "l ");
        this.lx = (float)x;
        this.ly = (float)y;
    }

    public void lineto(int x, int y) {
        this.newPath();
        if (this.lx != (float)x && this.ly != (float)y) {
            this.pw.print(this.cxy(x, y) + "l ");
        }
        this.lx = x;
        this.ly = y;
    }

    public void moveto(double x, double y) {
        this.newPath();
        this.pw.print(this.cxy(x, y) + "m ");
        this.lx = (float)x;
        this.ly = (float)y;
    }

    public void moveto(int x, int y) {
        this.newPath();
        if (this.lx != (float)x || this.ly != (float)y) {
            this.pw.print(this.cxy(x, y) + "m ");
        }
        this.lx = x;
        this.ly = y;
    }

    void newPath() {
        if (this.inText) {
            this.closeBlock();
        }
        if (!this.inStroke) {
            if (this.pre_np != null) {
                this.pw.print(this.pre_np);
                this.pre_np = null;
            }
            this.pw.print("n ");
        }
        this.inText = false;
        this.inStroke = true;
        this.ly = -9999.0f;
        this.lx = -9999.0f;
    }

    void newTextBlock(float x, float y) {
        if (this.inStroke) {
            this.closeBlock();
        }
        if (!this.inText) {
            this.getFont();
            this.pw.print("q BT ");
            this.ty = 0.0f;
            this.tx = 0.0f;
            this.pw.print(this.txy(x, y) + "Td ");
        } else {
            this.pw.print(this.twh(x, y, this.tx, this.ty) + "Td ");
        }
        this.tx = x;
        this.ty = y;
        if (this.newFont || !this.inText) {
            this.pw.print(this.pdffont.getName() + " " + this.font.getSize() + " Tf ");
        }
        this.newFont = false;
        this.inStroke = false;
        this.inText = true;
    }

    public void polygon(int[] xp, int[] yp, int np) {
        this.moveto(xp[0], yp[0]);
        for (int i = 1; i < np; ++i) {
            this.lineto(xp[i], yp[i]);
        }
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.clipRectangle = new Rectangle(x, y, w, h);
        this.closeBlock();
        this.drawRect(x, y, w, h);
        this.closeBlock("W n");
    }

    @Override
    public void setClip(Shape s) {
        Rectangle r = s.getBounds();
        this.setClip(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    public void setDefaultLineWidth() {
        this.closeBlock();
        this.pw.println("1 w");
    }

    @Override
    public void setFont(Font f) {
        if (this.font != f) {
            this.font = f;
            this.pdffont = this.page.getFont("/Type1", f.getName(), f.getStyle());
            this.newFont = true;
        }
    }

    private void setLineCap(int cap) {
        int lineCap = 0;
        switch (cap) {
            case 0: {
                lineCap = 0;
                break;
            }
            case 1: {
                lineCap = 1;
                break;
            }
            case 2: {
                lineCap = 2;
            }
        }
        if (this.lineCap != lineCap) {
            this.closeBlock();
            this.lineCap = lineCap;
            this.pw.println("" + lineCap + " J");
        }
    }

    private void setLineJoin(int join) {
        int lineJoin = 0;
        switch (join) {
            case 0: {
                lineJoin = 0;
                break;
            }
            case 1: {
                lineJoin = 1;
                break;
            }
            case 2: {
                lineJoin = 2;
            }
        }
        if (this.lineJoin != lineJoin) {
            this.closeBlock();
            this.lineJoin = lineJoin;
            this.pw.println("" + lineJoin + " j");
        }
    }

    public void setLineWidth(float width) {
        if (width != this.lineWidth) {
            this.closeBlock();
            this.lineWidth = width;
            this.pw.println("" + width + " w");
        }
    }

    private void setMiterLimit(float limit) {
        if (limit != this.miterLimit) {
            this.closeBlock();
            this.miterLimit = limit;
            this.pw.println("" + limit + " M");
        }
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        if (paint instanceof Color) {
            Color c = (Color)paint;
            double r = (double)c.getRed() / 255.0;
            double g = (double)c.getGreen() / 255.0;
            double b = (double)c.getBlue() / 255.0;
            this.closeBlock();
            this.pw.println("" + r + " " + g + " " + b + " rg " + r + " " + g + " " + b + " RG");
        }
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key arg0, Object arg1) {
        if (arg1 != null) {
            this.rhints.put(arg0, arg1);
        } else {
            this.rhints.remove(arg0);
        }
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.rhints.clear();
        this.rhints.putAll(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.originalStroke = s;
        this.stroke = this.transformStroke(s);
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.setLineCap(bs.getEndCap());
            this.setLineJoin(bs.getLineJoin());
            this.setLineWidth(bs.getLineWidth());
            this.setMiterLimit(bs.getMiterLimit());
        }
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.oTransform = t;
        this.transform = new AffineTransform(t);
        this.transform.concatenate(this.pTransform);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform tx) {
        this.transform.concatenate(tx);
        this.stroke = this.transformStroke(this.originalStroke);
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke st = (BasicStroke)stroke;
        float scale = (float)Math.sqrt(Math.abs(this.transform.getDeterminant()));
        float[] dash = st.getDashArray();
        if (dash != null) {
            int k = 0;
            while (k < dash.length) {
                int n = k++;
                dash[n] = dash[n] * scale;
            }
        }
        return new BasicStroke(st.getLineWidth() * scale, st.getEndCap(), st.getLineJoin(), st.getMiterLimit(), dash, st.getDashPhase() * scale);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        this.trax = (float)tx;
        this.tray = (float)ty;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    private String twh(float x, float y, float tx, float ty) {
        float nx = x;
        float ny = y;
        float ntx = tx;
        float nty = ty;
        int mh = (int)this.page.getPageFormat().getHeight();
        boolean sx = true;
        boolean sy = true;
        ny = (float)mh - y;
        nty = (float)mh - ty;
        nx = (float)sx * (nx - ntx);
        ny = (float)sy * (ny - nty);
        return "" + df.format(nx) + " " + df.format(ny) + " ";
    }

    private String txy(float x, float y) {
        Point2D.Float ptSrc = new Point2D.Float(x, y);
        Point2D.Float ptDst = new Point2D.Float();
        this.transform.transform(ptSrc, ptDst);
        return "" + df.format(((Point2D)ptDst).getX()) + " " + df.format(((Point2D)ptDst).getY()) + " ";
    }
}

