/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.timeline;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.timeline.FrameSelectionListener;
import com.jpexs.decompiler.flash.gui.timeline.TimelineBodyPanel;
import com.jpexs.decompiler.flash.gui.timeline.TimelineDepthPanel;
import com.jpexs.decompiler.flash.gui.timeline.TimelineTimePanel;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;

public class TimelinePanel
extends JPanel {
    private TimelineBodyPanel timelineBodyPanel;
    private TimelineTimePanel timePanel;
    private TimelineDepthPanel depthPanel;
    private Timeline timeline;
    public static final int FRAME_WIDTH = 8;
    public static final int FRAME_HEIGHT = 18;
    public static final Color selectedColor = new Color(255, 153, 153);
    public static final Color selectedBorderColor = new Color(204, 0, 0);

    public static Color getBackgroundColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.timelineBodyPanel.addFrameSelectionListener(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.timelineBodyPanel.removeFrameSelectionListener(l);
    }

    public void setTimelined(Timelined timelined) {
        this.removeAll();
        if (timelined == null) {
            this.revalidate();
            return;
        }
        this.timeline = timelined.getTimeline();
        this.timelineBodyPanel = new TimelineBodyPanel(this.timeline);
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.timelineBodyPanel);
        this.depthPanel = new TimelineDepthPanel(this.timeline);
        this.timePanel = new TimelineTimePanel();
        JPanel row1Panel = new JPanel();
        row1Panel.setLayout(new BorderLayout());
        JPanel sepPanel = new JPanel();
        sepPanel.setBackground(TimelinePanel.getBackgroundColor());
        sepPanel.setPreferredSize(new Dimension(this.depthPanel.getWidth(), this.timePanel.getHeight()));
        row1Panel.add((Component)sepPanel, "West");
        row1Panel.add((Component)this.timePanel, "Center");
        JPanel row2Panel = new JPanel();
        row2Panel.setLayout(new BorderLayout());
        row2Panel.add((Component)this.depthPanel, "West");
        row2Panel.add((Component)sp, "Center");
        this.add((Component)row1Panel, "North");
        this.add((Component)row2Panel, "Center");
        sp.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TimelinePanel.this.timePanel.scroll(e.getValue());
            }
        });
        sp.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TimelinePanel.this.depthPanel.scroll(e.getValue());
            }
        });
        final TimelineTimePanel ftime = this.timePanel;
        this.timelineBodyPanel.addFrameSelectionListener(new FrameSelectionListener(){

            @Override
            public void frameSelected(int frame, int depth) {
                ftime.frameSelect(frame);
            }
        });
        final TimelineBodyPanel ftimeline = this.timelineBodyPanel;
        this.timePanel.addFrameSelectionListener(new FrameSelectionListener(){

            @Override
            public void frameSelected(int frame, int depth) {
                ftimeline.frameSelect(frame, depth);
            }
        });
        this.revalidate();
    }
}

