/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.timeline;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.timeline.FrameSelectionListener;
import com.jpexs.decompiler.flash.gui.timeline.TimelinePanel;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Timeline;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class TimelineBodyPanel
extends JPanel
implements MouseListener,
KeyListener {
    private final Timeline timeline;
    public static final Color shapeTweenColor = new Color(89, 254, 124);
    public static final Color motionTweenColor = new Color(209, 172, 241);
    public static final Color borderColor = Color.black;
    public static final Color emptyBorderColor = new Color(189, 216, 252);
    public static final Color keyColor = Color.black;
    public static final Color aColor = Color.black;
    public static final Color stopColor = Color.white;
    public static final Color stopBorderColor = Color.black;
    public static final Color borderLinesColor = new Color(222, 222, 222);
    public static final int borderLinesLength = 2;
    public static final float fontSize = 10.0f;
    private final List<FrameSelectionListener> listeners = new ArrayList<FrameSelectionListener>();
    public Point cursor = null;

    public static Color getEmptyFrameColor() {
        return SubstanceColorUtilities.getLighterColor((Color)TimelineBodyPanel.getControlColor(), (double)0.7);
    }

    public static Color getEmptyFrameSecondColor() {
        return SubstanceColorUtilities.getLighterColor((Color)TimelineBodyPanel.getControlColor(), (double)0.9);
    }

    public static Color getSelectedColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
        }
        return SystemColor.textHighlight;
    }

    private static Color getControlColor() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            return SubstanceLookAndFeel.getCurrentSkin().getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        }
        return SystemColor.control;
    }

    public static Color getFrameColor() {
        return SubstanceColorUtilities.getDarkerColor((Color)TimelineBodyPanel.getControlColor(), (double)0.1);
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.add(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.remove(l);
    }

    public TimelineBodyPanel(Timeline timeline) {
        this.timeline = timeline;
        Dimension dim = new Dimension(8 * timeline.getFrameCount() + 1, 18 * timeline.getMaxDepth());
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        int max_f;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(TimelinePanel.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle clip = g.getClipBounds();
        int frameWidth = 8;
        int frameHeight = 18;
        int start_f = clip.x / frameWidth;
        int start_d = clip.y / frameHeight;
        int end_f = (clip.x + clip.width) / frameWidth;
        int end_d = (clip.y + clip.height) / frameHeight;
        int max_d = this.timeline.getMaxDepth();
        if (max_d < end_d) {
            end_d = max_d;
        }
        if ((max_f = this.timeline.getFrameCount() - 1) < end_f) {
            end_f = max_f;
        }
        if (end_d - start_d + 1 < 0) {
            return;
        }
        for (int f = start_f; f <= end_f; ++f) {
            g.setColor((f + 1) % 5 == 0 ? TimelineBodyPanel.getEmptyFrameSecondColor() : TimelineBodyPanel.getEmptyFrameColor());
            g.fillRect(f * frameWidth, start_d * frameHeight, frameWidth, (end_d - start_d + 1) * frameHeight);
            g.setColor(emptyBorderColor);
            for (int d = start_d; d <= end_d; ++d) {
                g.drawRect(f * frameWidth, d * frameHeight, frameWidth, frameHeight);
            }
        }
        if (this.cursor != null) {
            g.setColor(TimelineBodyPanel.getSelectedColor());
            g.fillRect(this.cursor.x * frameWidth + 1, this.cursor.y * frameHeight + 1, frameWidth - 1, frameHeight - 1);
        }
        g.setColor(aColor);
        g.setFont(this.getFont().deriveFont(10.0f));
        int awidth = g.getFontMetrics().stringWidth("a");
        for (int f = start_f; f <= end_f; ++f) {
            if (this.timeline.getFrame((int)f).actions.isEmpty()) continue;
            g.drawString("a", (float)(f * frameWidth + frameWidth / 2 - awidth / 2), (float)(frameHeight / 2) + 5.0f);
        }
        Map depthMaxFrames = this.timeline.getDepthMaxFrame();
        for (int d = start_d; d <= end_d; ++d) {
            DepthState ds;
            int start_f2;
            int maxFrame;
            int n = maxFrame = depthMaxFrames.containsKey(d) ? (Integer)depthMaxFrames.get(d) : -1;
            if (maxFrame < 0) continue;
            int end_f2 = Math.min(end_f, maxFrame);
            DepthState dsStart = (DepthState)this.timeline.getFrame((int)start_f2).layers.get(d);
            for (start_f2 = Math.min(start_f, end_f2); start_f2 >= 1 && dsStart == null == ((ds = (DepthState)this.timeline.getFrame((int)(start_f2 - 1)).layers.get(d)) == null) && (ds == null || dsStart.characterId == ds.characterId); --start_f2) {
            }
            for (int f = start_f2; f <= end_f2; ++f) {
                BlockType blockType;
                Color backColor;
                DepthState fl = (DepthState)this.timeline.getFrame((int)f).layers.get(d);
                boolean motionTween = fl == null ? false : fl.motionTween;
                DepthState flNext = f < max_f ? (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d) : null;
                DepthState flPrev = f > 0 ? (DepthState)this.timeline.getFrame((int)(f - 1)).layers.get(d) : null;
                CharacterTag cht = fl == null ? null : this.timeline.swf.getCharacter(fl.characterId);
                boolean shapeTween = cht != null && cht instanceof MorphShapeTag;
                boolean motionTweenStart = !motionTween && flNext != null && flNext.motionTween;
                boolean motionTweenEnd = !motionTween && flPrev != null && flPrev.motionTween;
                int draw_f = f;
                int num_frames = 1;
                if (fl == null) {
                    while (f + 1 < this.timeline.getFrameCount() && ((fl = (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d)) == null || fl.characterId == -1)) {
                        ++num_frames;
                        ++f;
                    }
                    backColor = TimelineBodyPanel.getEmptyFrameColor();
                    blockType = BlockType.EMPTY;
                } else {
                    while (f + 1 < this.timeline.getFrameCount() && (fl = (DepthState)this.timeline.getFrame((int)(f + 1)).layers.get(d)) != null && !fl.key) {
                        ++num_frames;
                        ++f;
                    }
                    Color color = shapeTween ? shapeTweenColor : (backColor = motionTween ? motionTweenColor : TimelineBodyPanel.getFrameColor());
                    blockType = shapeTween ? BlockType.SHAPE_TWEEN : (motionTween ? BlockType.MOTION_TWEEN : BlockType.NORMAL);
                }
                this.drawBlock(g, backColor, d, draw_f, num_frames, blockType);
            }
        }
        if (this.cursor != null && this.cursor.x >= start_f && this.cursor.x <= end_f) {
            g.setColor(TimelinePanel.selectedBorderColor);
            g.drawLine(this.cursor.x * frameWidth + frameWidth / 2, 0, this.cursor.x * frameWidth + frameWidth / 2, this.getHeight());
        }
    }

    private void drawBlock(Graphics2D g, Color backColor, int depth, int frame, int num_frames, BlockType blockType) {
        int frameWidth = 8;
        int frameHeight = 18;
        g.setColor(backColor);
        g.fillRect(frame * frameWidth, depth * frameHeight, num_frames * frameWidth, frameHeight);
        g.setColor(borderColor);
        g.drawRect(frame * frameWidth, depth * frameHeight, num_frames * frameWidth, frameHeight);
        boolean selected = false;
        if (this.cursor != null && frame <= this.cursor.x && frame + num_frames > this.cursor.x && depth == this.cursor.y) {
            selected = true;
        }
        if (selected) {
            g.setColor(TimelineBodyPanel.getSelectedColor());
            g.fillRect(this.cursor.x * frameWidth + 1, depth * frameHeight + 1, frameWidth - 1, frameHeight - 1);
        }
        boolean isTween = blockType == BlockType.MOTION_TWEEN || blockType == BlockType.SHAPE_TWEEN;
        g.setColor(keyColor);
        if (isTween) {
            g.drawLine(frame * frameWidth, depth * frameHeight + frameHeight * 3 / 4, frame * frameWidth + num_frames * frameWidth - frameWidth / 2, depth * frameHeight + frameHeight * 3 / 4);
        }
        if (blockType == BlockType.EMPTY) {
            g.drawOval(frame * frameWidth + frameWidth / 4, depth * frameHeight + frameHeight * 3 / 4 - frameWidth / 2 / 2, frameWidth / 2, frameWidth / 2);
        } else {
            g.fillOval(frame * frameWidth + frameWidth / 4, depth * frameHeight + frameHeight * 3 / 4 - frameWidth / 2 / 2, frameWidth / 2, frameWidth / 2);
        }
        if (num_frames > 1) {
            int endFrame = frame + num_frames - 1;
            if (isTween) {
                g.fillOval(endFrame * frameWidth + frameWidth / 4, depth * frameHeight + frameHeight * 3 / 4 - frameWidth / 2 / 2, frameWidth / 2, frameWidth / 2);
            } else {
                g.setColor(stopColor);
                g.fillRect(endFrame * frameWidth + frameWidth / 4, depth * frameHeight + frameHeight / 2 - 2, frameWidth / 2, frameHeight / 2);
                g.setColor(stopBorderColor);
                g.drawRect(endFrame * frameWidth + frameWidth / 4, depth * frameHeight + frameHeight / 2 - 2, frameWidth / 2, frameHeight / 2);
            }
            g.setColor(borderLinesColor);
            for (int n = frame + 1; n < frame + num_frames; ++n) {
                g.drawLine(n * frameWidth, depth * frameHeight + 1, n * frameWidth, depth * frameHeight + 2);
                g.drawLine(n * frameWidth, depth * frameHeight + frameHeight - 1, n * frameWidth, depth * frameHeight + frameHeight - 2);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void frameSelect(int frame, int depth) {
        if (this.cursor != null && this.cursor.x == frame && (this.cursor.y == depth || depth == -1)) {
            return;
        }
        if (depth == -1 && this.cursor != null) {
            depth = this.cursor.y;
        }
        this.cursor = new Point(frame, depth);
        for (FrameSelectionListener l : this.listeners) {
            l.frameSelected(frame, depth);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int maxDepth;
        Point p = e.getPoint();
        p.x /= 8;
        p.y /= 18;
        if (p.x >= this.timeline.getFrameCount()) {
            p.x = this.timeline.getFrameCount() - 1;
        }
        if (p.y > (maxDepth = this.timeline.getMaxDepth())) {
            p.y = maxDepth;
        }
        this.frameSelect(p.x, p.y);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                if (this.cursor.x <= 0) break;
                this.frameSelect(this.cursor.x - 1, this.cursor.y);
                break;
            }
            case 39: {
                if (this.cursor.x >= this.timeline.getFrameCount() - 1) break;
                this.frameSelect(this.cursor.x + 1, this.cursor.y);
                break;
            }
            case 38: {
                if (this.cursor.y <= 0) break;
                this.frameSelect(this.cursor.x, this.cursor.y - 1);
                break;
            }
            case 40: {
                if (this.cursor.y >= this.timeline.getMaxDepth()) break;
                this.frameSelect(this.cursor.x, this.cursor.y + 1);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private static enum BlockType {
        EMPTY,
        NORMAL,
        MOTION_TWEEN,
        SHAPE_TWEEN;

    }
}

