/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.player;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.FlashUnsupportedException;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.javactivex.ActiveX;
import com.jpexs.javactivex.ActiveXException;
import com.jpexs.javactivex.example.controls.flash.ShockwaveFlash;
import com.sun.jna.Platform;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FlashPlayerPanel
extends Panel
implements Closeable,
MediaDisplay {
    private final int setMovieDelay = (Integer)Configuration.setMovieDelay.get();
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private final ShockwaveFlash flash;
    private final Timer timer;
    private boolean stopped = true;
    private boolean closed = false;
    private float frameRate;
    private double zoom = 1.0;
    private String movieToPlay = null;
    private Thread playQueue;
    private final Object queueLock = new Object();

    @Override
    public boolean loopAvailable() {
        return false;
    }

    @Override
    public boolean screenAvailable() {
        return true;
    }

    @Override
    public boolean zoomAvailable() {
        return true;
    }

    @Override
    public double getZoomToFit() {
        return 1.0;
    }

    @Override
    public Zoom getZoom() {
        return null;
    }

    @Override
    public synchronized void zoom(Zoom zoom) {
        double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
        int zoomint = (int)Math.round(100.0 / (zoomDouble / this.zoom));
        if (zoomint == 0) {
            zoomint = 1;
        }
        if (zoomint > Short.MAX_VALUE) {
            zoomint = Short.MAX_VALUE;
        }
        if (zoomint == 100) {
            zoomint = 0;
        }
        this.flash.Zoom(0);
        this.flash.Zoom(zoomint);
    }

    public synchronized String getVariable(String name) throws IOException {
        return this.flash.GetVariable(name);
    }

    public synchronized void setVariable(String name, String value) throws IOException {
        this.flash.SetVariable(name, value);
    }

    public synchronized String call(String callString) throws IOException {
        return this.flash.CallFunction(callString);
    }

    @Override
    public synchronized int getCurrentFrame() {
        if (this.flash == null) {
            return 0;
        }
        try {
            return this.flash.getFrameNum();
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            return 0;
        }
    }

    @Override
    public synchronized int getTotalFrames() {
        if (this.flash == null) {
            return 0;
        }
        try {
            if (this.flash.getReadyState() == 4) {
                return this.flash.getTotalFrames();
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public synchronized void setBackground(Color color) {
        try {
            this.flash.setBackgroundColor((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue());
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public FlashPlayerPanel(Component frame) {
        if (!Platform.isWindows()) {
            throw new FlashUnsupportedException();
        }
        try {
            Callable<ShockwaveFlash> callable = new Callable<ShockwaveFlash>(){

                @Override
                public ShockwaveFlash call() throws InterruptedException {
                    return ActiveX.createObject(ShockwaveFlash.class, FlashPlayerPanel.this);
                }
            };
            this.flash = (ShockwaveFlash)CancellableWorker.call((Callable)callable, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ActiveXException | InterruptedException | ExecutionException | TimeoutException ex) {
            throw new FlashUnsupportedException();
        }
        this.flash.setAllowScriptAccess("always");
        try {
            this.flash.setAllowNetworking("all");
        }
        catch (ActiveXException activeXException) {
            // empty catch block
        }
        this.flash.addOnReadyStateChangeListener(axe -> this.fireMediaDisplayStateChanged());
        this.flash.addFlashCallListener(axe -> {
            String req = (String)axe.args.get("request");
            Matcher m = Pattern.compile("<invoke name=\"([^\"]+)\" returntype=\"xml\"><arguments><string>(.*)</string></arguments></invoke>").matcher(req);
            if (m.matches()) {
                String funname = m.group(1);
                String msg = m.group(2);
                if ((funname.equals("alert") || funname.equals("console.log")) && Main.debugDialog != null) {
                    Main.debugDialog.log(funname + ":" + msg);
                }
            }
        });
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){
            private boolean isPlaying = false;
            private int currentFrame = 0;

            @Override
            public void run() {
                if (FlashPlayerPanel.this.closed) {
                    return;
                }
                try {
                    ShockwaveFlash flash1 = FlashPlayerPanel.this.flash;
                    boolean changed = false;
                    if (flash1.getReadyState() >= 3) {
                        int currentFrame;
                        boolean isPlaying = flash1.IsPlaying();
                        if (this.isPlaying != isPlaying) {
                            this.isPlaying = isPlaying;
                        }
                        if (this.currentFrame != (currentFrame = flash1.CurrentFrame())) {
                            this.currentFrame = currentFrame;
                            changed = true;
                        }
                    } else {
                        this.isPlaying = false;
                    }
                    if (changed) {
                        FlashPlayerPanel.this.fireMediaDisplayStateChanged();
                    }
                }
                catch (Exception ex) {
                    this.cancel();
                }
            }
        }, 100L, 100L);
    }

    public synchronized void stopSWF() {
        this.displaySWF("-", null, 1.0f);
        this.stopped = true;
        this.fireMediaDisplayStateChanged();
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public BufferedImage printScreen() {
        Point screenloc = this.getLocationOnScreen();
        try {
            return new Robot().createScreenCapture(new Rectangle(screenloc.x, screenloc.y, this.getWidth(), this.getHeight()));
        }
        catch (AWTException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displaySWF(String flashName, Color bgColor, float frameRate) {
        if (this.playQueue == null) {
            this.playQueue = new Thread(){
                long lastTime;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        boolean empty;
                        Object object = FlashPlayerPanel.this.queueLock;
                        synchronized (object) {
                            boolean bl = empty = FlashPlayerPanel.this.movieToPlay == null;
                            if (empty) {
                                try {
                                    FlashPlayerPanel.this.queueLock.wait();
                                }
                                catch (InterruptedException ex) {
                                    break;
                                }
                            }
                        }
                        if (empty) continue;
                        FlashPlayerPanel.this.flash.setMovie(FlashPlayerPanel.this.movieToPlay);
                        object = FlashPlayerPanel.this.queueLock;
                        synchronized (object) {
                            FlashPlayerPanel.this.movieToPlay = null;
                        }
                        try {
                            Thread.sleep(FlashPlayerPanel.this.setMovieDelay);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                }
            };
            this.playQueue.start();
        }
        this.zoom = 1.0;
        this.frameRate = frameRate;
        if (bgColor != null) {
            this.setBackground(bgColor);
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.movieToPlay = flashName;
            this.queueLock.notify();
        }
        this.stopped = false;
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized void close() throws IOException {
        this.timer.cancel();
        this.closed = true;
    }

    @Override
    public void pause() {
        try {
            if (this.flash.getReadyState() >= 3) {
                this.flash.Stop();
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        try {
            if (this.flash.getReadyState() >= 3) {
                this.flash.Stop();
                this.flash.Rewind();
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void rewind() {
        try {
            if (this.flash.getReadyState() >= 3) {
                this.flash.Rewind();
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void play() {
        try {
            if (this.flash.getReadyState() >= 3) {
                this.flash.Play();
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean isPlaying() {
        try {
            if (this.flash.getReadyState() >= 3) {
                return this.flash.IsPlaying();
            }
            return false;
        }
        catch (ActiveXException | NullPointerException ex) {
            return false;
        }
    }

    @Override
    public void setLoop(boolean loop) {
    }

    @Override
    public void gotoFrame(int frame) {
        if (frame < 0) {
            return;
        }
        if (frame >= this.getTotalFrames()) {
            return;
        }
        try {
            if (this.flash.getReadyState() >= 3) {
                this.flash.GotoFrame(frame);
            }
        }
        catch (ActiveXException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public float getFrameRate() {
        return this.frameRate;
    }

    @Override
    public boolean isLoaded() {
        return !this.isStopped();
    }

    public void fireMediaDisplayStateChanged() {
        for (MediaDisplayListener l : this.listeners) {
            l.mediaDisplayStateChanged(this);
        }
    }

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }
}

