/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.pipes;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;

public class PipeInputStream
extends InputStream {
    protected WinNT.HANDLE pipe;
    private boolean closed = false;

    public PipeInputStream(String pipeName, boolean newpipe) throws IOException {
        if (!Platform.isWindows()) {
            throw new IOException("Cannot create Pipe on nonWindows OS");
        }
        String fullPipePath = "\\\\.\\pipe\\" + pipeName;
        if (newpipe) {
            this.pipe = Kernel32.INSTANCE.CreateNamedPipe(fullPipePath, 1, 0, 1, 4096, 4096, 0, null);
            if (this.pipe == null || !Kernel32.INSTANCE.ConnectNamedPipe(this.pipe, null)) {
                throw new IOException("Cannot connect to the pipe");
            }
        } else {
            this.pipe = Kernel32.INSTANCE.CreateFile(fullPipePath, Integer.MIN_VALUE, 1, null, 3, 128, null);
        }
        if (this.pipe == null) {
            throw new IOException("Cannot connect to the pipe");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    PipeInputStream.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            Kernel32.INSTANCE.CloseHandle(this.pipe);
            this.closed = true;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] d = new byte[1];
        if (this.readPipe(d) == 0) {
            return -1;
        }
        return d[0];
    }

    private int readPipe(byte[] res) throws IOException {
        int read;
        int readNow;
        IntByReference ibr = new IntByReference();
        for (read = 0; read < res.length; read += readNow) {
            byte[] data = new byte[res.length - read];
            boolean result = Kernel32.INSTANCE.ReadFile(this.pipe, data, data.length, ibr, null);
            if (!result) {
                throw new IOException("Cannot read pipe. Error " + Kernel32.INSTANCE.GetLastError());
            }
            readNow = ibr.getValue();
            System.arraycopy(data, 0, res, read, readNow);
        }
        return read;
    }
}

