/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.debugger;

import com.jpexs.decompiler.flash.gui.debugger.DebugListener;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Debugger {
    private static final Set<DebugListener> listeners = new HashSet<DebugListener>();
    private final int port;
    private DebugServerThread server = null;

    public synchronized void addMessageListener(DebugListener l) {
        listeners.add(l);
    }

    public synchronized void removeMessageListener(DebugListener l) {
        listeners.remove(l);
    }

    public Debugger(int port) {
        this.port = port;
    }

    public synchronized void start() {
        if (this.server == null) {
            this.server = new DebugServerThread(this.port);
            this.server.start();
        }
    }

    public synchronized boolean isRunning() {
        return this.server != null;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (DebugHandler h : this.server.handlers.values()) {
                h.cancel();
            }
            this.server.handlers.clear();
            this.server = null;
        }
    }

    private static class DebugServerThread
    extends Thread {
        private final int port;
        private ServerSocket ss;
        private final Map<Integer, DebugHandler> handlers = new WeakHashMap<Integer, DebugHandler>();

        public DebugServerThread(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                this.ss = new ServerSocket(this.port, 50, InetAddress.getByName("localhost"));
                this.ss.setReuseAddress(true);
                while (true) {
                    Socket s = this.ss.accept();
                    DebugHandler h = new DebugHandler(this.port, s);
                    this.handlers.put(h.id, h);
                    h.start();
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private static class DebugHandler
    extends Thread {
        private final Socket s;
        private final int serverPort;
        private static int maxid = 0;
        private final int id;
        public boolean finished = false;
        private final Map<String, String> parameters = new HashMap<String, String>();
        public static final int MSG_STRING = 0;
        public static final int MSG_LOADER_URL = 1;
        public static final int MSG_LOADER_BYTES = 2;

        public String getParameter(String name, String defValue) {
            if (this.parameters.containsKey(name)) {
                return this.parameters.get(name);
            }
            return defValue;
        }

        public int getVersionMajor() {
            return Integer.parseInt(this.getParameter("debug.version.major", "1"));
        }

        public int getVersionMinor() {
            return Integer.parseInt(this.getParameter("debug.version.major", "0"));
        }

        public boolean hasMsgType() {
            return this.getVersionMajor() > 1 || this.getVersionMinor() > 0;
        }

        public DebugHandler(int serverPort, Socket s) {
            this.s = s;
            this.id = maxid++;
            this.serverPort = serverPort;
        }

        public void cancel() {
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private int readType(InputStream is) throws IOException {
            int type = is.read();
            if (type == -1) {
                throw new EOFException();
            }
            return type;
        }

        private byte[] readBytes(InputStream is) throws IOException {
            int cnt;
            int len = is.read();
            if (len == -1) {
                throw new EOFException();
            }
            int len2 = is.read();
            if (len2 == -1) {
                throw new EOFException();
            }
            int len3 = is.read();
            if (len3 == -1) {
                throw new EOFException();
            }
            int len4 = is.read();
            if (len4 == -1) {
                throw new EOFException();
            }
            len = (len << 24) + (len2 << 16) + (len3 << 8) + len4;
            byte[] data = new byte[len];
            int off = 0;
            while (len > 0 && (cnt = is.read(data, off, len)) > 0) {
                len -= cnt;
                off += cnt;
            }
            return data;
        }

        private String readString(InputStream is) throws IOException {
            int len = is.read();
            if (len == -1) {
                throw new EOFException();
            }
            int len2 = is.read();
            if (len2 == -1) {
                throw new EOFException();
            }
            len = (len << 8) + len2;
            byte[] buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                int rd = is.read();
                if (rd == -1) {
                    throw new EOFException();
                }
                buf[i] = (byte)rd;
            }
            return new String(buf, Utf8Helper.charset);
        }

        @Override
        public void run() {
            String clientName;
            block47: {
                clientName = Integer.toString(this.id);
                try (InputStream is = this.s.getInputStream();){
                    int c;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    do {
                        if ((c = is.read()) == 0) continue;
                        baos.write(c);
                    } while (c > 0);
                    String ret = baos.toString("UTF-8");
                    if (ret.equals("<policy-file-request/>")) {
                        try (OutputStream os = this.s.getOutputStream();){
                            os.write(("<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + this.serverPort + "\" /></cross-domain-policy>").getBytes("UTF-8"));
                            break block47;
                        }
                    }
                    if (!ret.isEmpty()) {
                        String[] param;
                        String[] stringArray;
                        if (ret.contains(";")) {
                            stringArray = ret.split(";");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = ret;
                        }
                        for (String p : param = stringArray) {
                            if (p.contains("=")) {
                                String key = p.substring(0, p.indexOf(61));
                                String val = p.substring(p.indexOf(61) + 1);
                                this.parameters.put(key, val);
                                continue;
                            }
                            this.parameters.put(p, "true");
                        }
                    }
                    boolean hasType = this.hasMsgType();
                    String name = this.readString(is);
                    if (!name.isEmpty()) {
                        clientName = name;
                    }
                    block29: while (true) {
                        int type = 0;
                        if (hasType) {
                            type = this.readType(is);
                        }
                        switch (type) {
                            case 0: {
                                DebugListener l;
                                ret = this.readString(is);
                                Iterator iterator = listeners.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block29;
                                    l = (DebugListener)iterator.next();
                                    l.onMessage(clientName, ret);
                                }
                            }
                            case 1: {
                                DebugListener l;
                                ret = this.readString(is);
                                Iterator iterator = listeners.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block29;
                                    l = (DebugListener)iterator.next();
                                    l.onLoaderURL(clientName, ret);
                                }
                            }
                            case 2: {
                                byte[] retB = this.readBytes(is);
                                for (DebugListener l : listeners) {
                                    l.onLoaderBytes(clientName, retB);
                                }
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.finished = true;
            for (DebugListener l : listeners) {
                l.onFinish(clientName);
            }
        }
    }
}

