/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundTagPlayer
implements MediaDisplay {
    private final Clip clip;
    private int loopCount;
    private boolean paused = false;
    private final Object playLock = new Object();
    private final SoundTag tag;
    private final Timer timer;
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private boolean rewindAfterStop = false;
    private static final int FRAME_DIVISOR = 8000;

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }

    public void fireMediaDisplayStateChanged() {
        for (MediaDisplayListener l : this.listeners) {
            l.mediaDisplayStateChanged(this);
        }
    }

    private void firePlayingFinished() {
        for (MediaDisplayListener l : this.listeners) {
            l.playingFinished(this);
        }
    }

    public SoundTagPlayer(final SoundTag tag, int loops, boolean async) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.tag = tag;
        this.loopCount = loops;
        this.clip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
        this.clip.addLineListener(new LineListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP) {
                    Object object = SoundTagPlayer.this.playLock;
                    synchronized (object) {
                        if (!SoundTagPlayer.this.paused) {
                            SoundTagPlayer.this.decreaseLoopCount();
                            if (SoundTagPlayer.this.loopCount > 0) {
                                SoundTagPlayer.this.clip.setFramePosition(0);
                                SoundTagPlayer.this.clip.start();
                            } else {
                                SoundTagPlayer.this.firePlayingFinished();
                            }
                        }
                    }
                    if (SoundTagPlayer.this.rewindAfterStop) {
                        SoundTagPlayer.this.rewind();
                        SoundTagPlayer.this.rewindAfterStop = false;
                    }
                }
                SoundTagPlayer.this.fireMediaDisplayStateChanged();
            }
        });
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SoundTagPlayer.this.fireMediaDisplayStateChanged();
                }
                catch (Exception ex) {
                    this.cancel();
                }
            }
        }, 100L, 100L);
        if (!async) {
            this.paused = true;
            this.openSound(tag);
        } else {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SoundTagPlayer.this.openSound(tag);
                    }
                    catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
                        Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Object object = SoundTagPlayer.this.playLock;
                    synchronized (object) {
                        if (!SoundTagPlayer.this.paused) {
                            SoundTagPlayer.this.play();
                        }
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSound(SoundTag tag) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        SWF swf = ((Tag)tag).getSwf();
        byte[] wavData = swf.getFromCache(tag);
        if (wavData == null) {
            List soundData = tag.getRawSoundData();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tag.getSoundFormat().createWav(soundData, (OutputStream)baos);
            wavData = baos.toByteArray();
            swf.putToCache(tag, wavData);
        }
        Object object = this.playLock;
        synchronized (object) {
            this.clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(wavData)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFrame() {
        Object object = this.playLock;
        synchronized (object) {
            return (int)(this.clip.getMicrosecondPosition() / 8000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalFrames() {
        Object object = this.playLock;
        synchronized (object) {
            return (int)(this.clip.getMicrosecondLength() / 8000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.playLock;
        synchronized (object) {
            this.paused = true;
            this.clip.stop();
        }
    }

    @Override
    public void stop() {
        this.rewindAfterStop = true;
        this.pause();
        this.rewind();
    }

    @Override
    public void close() {
        this.stop();
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        Object object = this.playLock;
        synchronized (object) {
            this.paused = false;
            if (!this.clip.isActive()) {
                if (this.clip.getMicrosecondLength() == this.clip.getMicrosecondPosition()) {
                    this.decreaseLoopCount();
                    this.clip.setFramePosition(0);
                }
                this.clip.start();
            }
        }
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void rewind() {
        this.gotoFrame(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlaying() {
        Object object = this.playLock;
        synchronized (object) {
            return this.clip.isActive();
        }
    }

    @Override
    public boolean loopAvailable() {
        return true;
    }

    @Override
    public boolean screenAvailable() {
        return false;
    }

    @Override
    public void zoom(Zoom zoom) {
    }

    @Override
    public boolean zoomAvailable() {
        return false;
    }

    @Override
    public double getZoomToFit() {
        return 1.0;
    }

    @Override
    public Zoom getZoom() {
        return null;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loopCount = loop ? Integer.MAX_VALUE : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotoFrame(int frame) {
        Object object = this.playLock;
        synchronized (object) {
            this.clip.setMicrosecondPosition((long)frame * 8000L);
        }
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public float getFrameRate() {
        return 125.0f;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public BufferedImage printScreen() {
        return null;
    }

    protected void finalize() throws Throwable {
        try {
            this.timer.cancel();
            if (this.clip != null) {
                this.clip.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void decreaseLoopCount() {
        if (this.loopCount > 0 && this.loopCount != Integer.MAX_VALUE) {
            --this.loopCount;
        }
    }
}

