/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.DocumentSearchData;

public class SearchPanel<E>
extends JPanel {
    private final SearchListener<E> listener;
    private final JLabel searchPos;
    private int foundPos = 0;
    private final JLabel searchForLabel;
    private String searchFor;
    private boolean searchIgnoreCase;
    private boolean searchRegexp;
    private List<E> found = new ArrayList();

    public SearchPanel(LayoutManager lm, SearchListener<E> listener) {
        super(lm);
        this.listener = listener;
        JButton prevSearchButton = new JButton(View.getIcon("prev16"));
        prevSearchButton.setMargin(new Insets(3, 3, 3, 3));
        prevSearchButton.addActionListener(this::prevButtonActionPerformed);
        JButton nextSearchButton = new JButton(View.getIcon("next16"));
        nextSearchButton.setMargin(new Insets(3, 3, 3, 3));
        nextSearchButton.addActionListener(this::nextButtonActionPerformed);
        JButton cancelSearchButton = new JButton(View.getIcon("cancel16"));
        cancelSearchButton.setMargin(new Insets(3, 3, 3, 3));
        cancelSearchButton.addActionListener(this::cancelButtonActionPerformed);
        this.searchPos = new JLabel("0/0");
        this.searchForLabel = new JLabel(AppStrings.translate("search.info").replace("%text%", ""));
        this.add(this.searchForLabel);
        this.add(prevSearchButton);
        this.add(new JLabel(AppStrings.translate("search.script") + " "));
        this.add(this.searchPos);
        this.add(nextSearchButton);
        this.add(cancelSearchButton);
        this.setVisible(false);
    }

    public void showQuickFindDialog(JTextComponent editor) {
        DocumentSearchData dsd = DocumentSearchData.getFromEditor((JTextComponent)editor);
        dsd.setPattern(this.searchFor, this.searchRegexp, this.searchIgnoreCase);
        dsd.showQuickFindDialogEx(editor, this.searchIgnoreCase, this.searchRegexp);
    }

    public void setSearchText(String txt) {
        this.searchFor = txt;
        this.searchForLabel.setText(AppStrings.translate("search.info").replace("%text%", txt) + " ");
    }

    public boolean setResults(List<E> results) {
        this.found = results;
        if (this.found.isEmpty()) {
            this.setVisible(false);
            return false;
        }
        this.setPos(0);
        this.setVisible(true);
        return true;
    }

    public void setOptions(boolean ignoreCase, boolean regExp) {
        this.searchIgnoreCase = ignoreCase;
        this.searchRegexp = regExp;
    }

    public void setPos(int pos) {
        this.foundPos = pos;
        this.doUpdate();
    }

    public void clear() {
        this.foundPos = 0;
        this.found.clear();
    }

    private void doUpdate() {
        View.execInEventDispatchLater(() -> {
            this.searchPos.setText(this.foundPos + 1 + "/" + this.found.size());
            this.listener.updateSearchPos(this.found.get(this.foundPos));
        });
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.foundPos = 0;
        this.setVisible(false);
        this.found = new ArrayList();
        this.searchFor = null;
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        --this.foundPos;
        if (this.foundPos < 0) {
            this.foundPos += this.found.size();
        }
        this.doUpdate();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.foundPos = (this.foundPos + 1) % this.found.size();
        this.doUpdate();
    }
}

