/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class MyResizableIcon
implements Icon {
    protected BufferedImage originalImage;
    protected Map<String, BufferedImage> cachedImages = new HashMap<String, BufferedImage>();
    protected int width;
    protected int height;
    protected BufferedImage image;

    public MyResizableIcon(BufferedImage originalImage) {
        this.originalImage = originalImage;
        this.width = originalImage.getWidth();
        this.height = originalImage.getHeight();
    }

    public void setDimension(Dimension dim) {
        this.setIconSize(dim.width, dim.height);
    }

    public void setIconSize(int renderWidth, int renderHeight) {
        float scaleY;
        this.width = renderWidth;
        this.height = renderHeight;
        String key = renderWidth + ":" + renderHeight;
        if (this.cachedImages.containsKey(key)) {
            this.image = this.cachedImages.get(key);
            return;
        }
        BufferedImage result = this.originalImage;
        float scaleX = (float)this.originalImage.getWidth() / (float)renderWidth;
        float scale = Math.max(scaleX, scaleY = (float)this.originalImage.getHeight() / (float)renderHeight);
        if (scale > 1.0f) {
            int finalWidth = (int)((float)this.originalImage.getWidth() / scale);
            result = FlamingoUtilities.createThumbnail((BufferedImage)this.originalImage, (int)finalWidth);
        }
        this.cachedImages.put(renderWidth + ":" + renderHeight, result);
        this.image = result;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image != null) {
            int dx = (this.width - this.image.getWidth()) / 2;
            int dy = (this.height - this.image.getHeight()) / 2;
            g.drawImage(this.image, x + dx, y + dy, null);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

