/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.Amf3ValueEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BinaryDataEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BooleanEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.ColorEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.NumberEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.StringEditor;
import com.jpexs.decompiler.flash.gui.helpers.SpringUtilities;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Calculated;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.decompiler.flash.types.annotations.Optional;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.parser.AnnotationParseException;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionEvaluator;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class GenericTagPanel
extends JPanel
implements ChangeListener {
    private static final Logger logger = Logger.getLogger(GenericTagPanel.class.getName());
    protected final MainPanel mainPanel;
    private final JEditorPane genericTagPropertiesEditorPane;
    private final JPanel genericTagPropertiesEditPanel;
    private final JScrollPane genericTagPropertiesEditorPaneScrollPanel;
    private final JScrollPane genericTagPropertiesEditPanelScrollPanel;
    private Tag tag;
    private Tag editedTag;
    private List<String> keys = new ArrayList<String>();
    private Map<String, GenericTagEditor> editors = new HashMap<String, GenericTagEditor>();
    private Map<String, Component> labels = new HashMap<String, Component>();
    private Map<String, Component> types = new HashMap<String, Component>();
    private Map<String, List<Field>> fieldPaths = new HashMap<String, List<Field>>();
    private Map<String, List<Integer>> fieldIndices = new HashMap<String, List<Integer>>();
    private HeaderLabel hdr;
    private Set<String> addKeys = new HashSet<String>();
    private Map<String, Component> addButtons = new HashMap<String, Component>();
    private Map<String, Component> removeButtons = new HashMap<String, Component>();

    public GenericTagPanel(MainPanel mainPanel) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.hdr = new HeaderLabel("");
        this.add((Component)this.hdr, "North");
        this.genericTagPropertiesEditorPane = new JEditorPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this.genericTagPropertiesEditorPane.setEditable(false);
        this.genericTagPropertiesEditorPaneScrollPanel = new JScrollPane(this.genericTagPropertiesEditorPane);
        this.add((Component)this.genericTagPropertiesEditorPaneScrollPanel, "Center");
        this.genericTagPropertiesEditPanel = new JPanel();
        this.genericTagPropertiesEditPanel.setLayout(new SpringLayout());
        JPanel edPanel = new JPanel(new BorderLayout());
        edPanel.add((Component)this.genericTagPropertiesEditPanel, "North");
        this.genericTagPropertiesEditPanelScrollPanel = new JScrollPane(edPanel);
    }

    public void clear() {
        this.editors.clear();
        this.fieldPaths.clear();
        this.fieldIndices.clear();
        this.labels.clear();
        this.types.clear();
        this.keys.clear();
        this.addKeys.clear();
        this.addButtons.clear();
        this.removeButtons.clear();
        this.genericTagPropertiesEditPanel.removeAll();
        this.genericTagPropertiesEditPanel.setSize(0, 0);
    }

    public void setEditMode(boolean edit, Tag tag) {
        if (tag == null) {
            tag = this.tag;
        }
        this.tag = tag;
        this.editedTag = (Tag)Helper.deepCopy((Object)tag);
        this.generateEditControls(this.editedTag, !edit);
        if (edit) {
            this.remove(this.genericTagPropertiesEditorPaneScrollPanel);
            this.add((Component)this.genericTagPropertiesEditPanelScrollPanel, "Center");
        } else {
            this.genericTagPropertiesEditPanel.removeAll();
            this.genericTagPropertiesEditPanel.setSize(0, 0);
            this.remove(this.genericTagPropertiesEditPanelScrollPanel);
            this.add((Component)this.genericTagPropertiesEditorPaneScrollPanel, "Center");
            this.setTagText(this.tag);
        }
        this.revalidate();
        this.repaint();
    }

    private void setTagText(Tag tag) {
        this.clear();
        this.generateEditControls(tag, true);
        StringBuilder val = new StringBuilder();
        for (String key : this.keys) {
            GenericTagEditor ed = this.editors.get(key);
            if (!((Component)((Object)ed)).isVisible()) continue;
            val.append(key).append(" : ").append(ed.getReadOnlyValue()).append("<br>");
        }
        val.insert(0, "<html>").append("</html>");
        this.genericTagPropertiesEditorPane.setContentType("text/html");
        this.genericTagPropertiesEditorPane.setText(val.toString());
        this.genericTagPropertiesEditorPane.setCaretPosition(0);
        this.hdr.setText(tag.toString());
    }

    private void generateEditControls(Tag tag, boolean readonly) {
        this.clear();
        this.generateEditControlsRecursive(tag, "", new ArrayList<Field>(), new ArrayList<Integer>(), readonly);
        this.change(null);
    }

    private void relayout(int propCount) {
        SpringUtilities.makeCompactGrid(this.genericTagPropertiesEditPanel, propCount, 3, 6, 6, 6, 6);
        this.revalidate();
        this.repaint();
    }

    private int generateEditControlsRecursive(final Object obj, String parent, List<Field> parentFields, List<Integer> parentIndices, boolean readonly) {
        if (obj == null) {
            return 0;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        int propCount = 0;
        for (final Field field : fields) {
            try {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                String name = parent + field.getName();
                Object value = field.get(obj);
                if (List.class.isAssignableFrom(field.getType())) {
                    if (value != null) {
                        int i = 0;
                        for (Object obj1 : (Iterable)value) {
                            String subname = name + "[" + i + "]";
                            propCount += this.addEditor(subname, obj, field, i, obj1.getClass(), obj1, parentFields, parentIndices, readonly);
                            final int fi = i++;
                            JButton removeButton = new JButton(View.getIcon("close16"));
                            removeButton.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagPanel.this.removeItem(obj, field, fi);
                                }
                            });
                            this.removeButtons.put(subname, removeButton);
                        }
                    }
                } else if (field.getType().isArray()) {
                    if (value != null) {
                        int i = 0;
                        while (i < Array.getLength(value)) {
                            Object item = Array.get(value, i);
                            String subname = name + "[" + i + "]";
                            propCount += this.addEditor(subname, obj, field, i, item.getClass(), item, parentFields, parentIndices, readonly);
                            final int fi = i++;
                            JButton removeButton = new JButton(View.getIcon("close16"));
                            removeButton.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagPanel.this.removeItem(obj, field, fi);
                                }
                            });
                            this.removeButtons.put(subname, removeButton);
                        }
                    }
                } else {
                    propCount += this.addEditor(name, obj, field, 0, field.getType(), value, parentFields, parentIndices, readonly);
                }
                if (!ReflectionTools.needsIndex((Field)field) || readonly || field.getName().equals("clipActionRecords")) continue;
                JButton addButton = new JButton(View.getIcon("add16"));
                addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GenericTagPanel.this.addItem(obj, field);
                    }
                });
                name = name + "[]";
                ArrayList<Field> parList = new ArrayList<Field>(parentFields);
                parList.add(field);
                this.fieldPaths.put(name, parList);
                ArrayList<Integer> parIndices = new ArrayList<Integer>(parentIndices);
                parIndices.add(0);
                this.fieldIndices.put(name, parIndices);
                this.addRow(name, addButton, field);
                this.addKeys.add(name);
                this.addButtons.put(name, addButton);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return propCount;
    }

    private void removeItem(Object obj, Field field, int index) {
        JScrollBar sb = this.genericTagPropertiesEditPanelScrollPanel.getVerticalScrollBar();
        final int val = sb.getValue();
        SWFType swfType = field.getAnnotation(SWFType.class);
        if (swfType != null && !swfType.countField().isEmpty()) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (int f = 0; f < fields.length; ++f) {
                SWFType fieldSwfType = fields[f].getAnnotation(SWFType.class);
                if (fieldSwfType == null || !fieldSwfType.countField().equals(swfType.countField())) continue;
                ReflectionTools.removeFromField((Object)obj, (Field)fields[f], (int)index);
            }
            try {
                Field countField = obj.getClass().getDeclaredField(swfType.countField());
                int cnt = countField.getInt(obj);
                countField.setInt(obj, --cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        } else {
            ReflectionTools.removeFromField((Object)obj, (Field)field, (int)index);
        }
        this.generateEditControls(this.editedTag, false);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                View.execInEventDispatch(() -> GenericTagPanel.this.genericTagPropertiesEditPanelScrollPanel.getVerticalScrollBar().setValue(val));
            }
        }.start();
        this.revalidate();
        this.repaint();
    }

    private void addItem(Object obj, Field field) {
        JScrollBar sb = this.genericTagPropertiesEditPanelScrollPanel.getVerticalScrollBar();
        final int val = sb.getValue();
        SWFType swfType = field.getAnnotation(SWFType.class);
        if (swfType != null && !swfType.countField().isEmpty()) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (int f = 0; f < fields.length; ++f) {
                SWFType fieldSwfType = fields[f].getAnnotation(SWFType.class);
                if (fieldSwfType == null || !fieldSwfType.countField().equals(swfType.countField())) continue;
                ReflectionTools.addToField((Object)obj, (Field)fields[f], (int)ReflectionTools.getFieldSubSize((Object)obj, (Field)fields[f]), (boolean)true, null);
            }
            try {
                Field countField = obj.getClass().getDeclaredField(swfType.countField());
                int cnt = countField.getInt(obj);
                countField.setInt(obj, ++cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        } else {
            ReflectionTools.addToField((Object)obj, (Field)field, (int)ReflectionTools.getFieldSubSize((Object)obj, (Field)field), (boolean)true, null);
        }
        this.generateEditControls(this.editedTag, false);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                View.execInEventDispatch(() -> GenericTagPanel.this.genericTagPropertiesEditPanelScrollPanel.getVerticalScrollBar().setValue(val));
            }
        }.start();
        this.revalidate();
        this.repaint();
    }

    private int addEditor(String name, Object obj, Field field, int index, Class<?> type, Object value, List<Field> parentList, List<Integer> parentIndices, boolean readonly) throws IllegalArgumentException, IllegalAccessException {
        JComponent editor;
        Calculated calculated = field.getAnnotation(Calculated.class);
        if (calculated != null) {
            return 0;
        }
        ArrayList<Field> parList = new ArrayList<Field>(parentList);
        parList.add(field);
        ArrayList<Integer> parIndices = new ArrayList<Integer>(parentIndices);
        parIndices.add(index);
        Internal inter = field.getAnnotation(Internal.class);
        if (inter != null) {
            return 0;
        }
        SWFType swfType = field.getAnnotation(SWFType.class);
        Multiline multiline = field.getAnnotation(Multiline.class);
        if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(Float.TYPE) || type.equals(Float.class)) {
            editor = new NumberEditor(name, obj, field, index, type, swfType);
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            editor = new BooleanEditor(name, obj, field, index, type);
        } else if (type.equals(String.class)) {
            editor = new StringEditor(name, obj, field, index, type, multiline != null);
        } else if (type.equals(RGB.class) || type.equals(RGBA.class) || type.equals(ARGB.class)) {
            editor = new ColorEditor(name, obj, field, index, type);
        } else if (type.equals(ByteArrayRange.class)) {
            editor = new BinaryDataEditor(this.mainPanel, name, obj, field, index, type);
        } else if (type.equals(Amf3Value.class)) {
            editor = new Amf3ValueEditor(name, obj, field, index, type);
        } else {
            if (value == null) {
                if (readonly) {
                    return 0;
                }
                Optional opt = field.getAnnotation(Optional.class);
                if (opt == null) {
                    try {
                        value = ReflectionTools.newInstanceOf(field.getType());
                        field.set(obj, value);
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            return this.generateEditControlsRecursive(value, name + ".", parList, parIndices, readonly);
        }
        if (editor instanceof GenericTagEditor) {
            GenericTagEditor ce = editor;
            ce.addChangeListener(this);
            this.editors.put(name, ce);
            this.fieldPaths.put(name, parList);
            this.fieldIndices.put(name, parIndices);
            this.addRow(name, editor, field);
            ce.added();
        }
        return 1;
    }

    private void addRow(String name, Component editor, Field field) {
        JLabel label = new JLabel(name + ":", 11);
        label.setVerticalAlignment(1);
        this.genericTagPropertiesEditPanel.add(label);
        label.setLabelFor(editor);
        this.labels.put(name, label);
        this.genericTagPropertiesEditPanel.add(editor);
        JLabel typeLabel = new JLabel(this.swfTypeToString(field.getAnnotation(SWFType.class)), 11);
        typeLabel.setVerticalAlignment(1);
        this.genericTagPropertiesEditPanel.add(typeLabel);
        this.types.put(name, typeLabel);
        this.keys.add(name);
    }

    public String swfTypeToString(SWFType swfType) {
        if (swfType == null) {
            return null;
        }
        String result = swfType.value().toString();
        if (swfType.count() > 0) {
            result = result + "[" + swfType.count();
            if (swfType.countAdd() > 0) {
                result = result + " + " + swfType.countAdd();
            }
            result = result + "]";
        } else if (!swfType.countField().isEmpty()) {
            result = result + "[" + swfType.countField();
            if (swfType.countAdd() > 0) {
                result = result + " + " + swfType.countAdd();
            }
            result = result + "]";
        }
        return result;
    }

    private void assignTag(Tag t, Tag assigned) {
        if (t.getClass() != assigned.getClass()) {
            return;
        }
        for (Field f : t.getClass().getDeclaredFields()) {
            if ((f.getModifiers() & 0x10) == 16 || (f.getModifiers() & 8) == 8) continue;
            try {
                f.set(t, f.get(assigned));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean save() {
        for (Component component : this.genericTagPropertiesEditPanel.getComponents()) {
            if (!(component instanceof GenericTagEditor)) continue;
            try {
                ((GenericTagEditor)((Object)component)).validateValue();
                ((GenericTagEditor)((Object)component)).save();
            }
            catch (IllegalArgumentException iex) {
                return false;
            }
        }
        SWF swf = this.tag.getSwf();
        this.assignTag(this.tag, this.editedTag);
        this.tag.setModified(true);
        this.tag.setSwf(swf);
        this.setTagText(this.tag);
        return true;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public void change(GenericTagEditor ed) {
        block2: for (String key : this.editors.keySet()) {
            GenericTagEditor dependentEditor = this.editors.get(key);
            Component dependentLabel = this.labels.get(key);
            Component dependentTypeLabel = this.types.get(key);
            List<Field> path = this.fieldPaths.get(key);
            List<Integer> indices = this.fieldIndices.get(key);
            String p = "";
            boolean conditionMet = true;
            for (int i = 0; i < path.size(); ++i) {
                Conditional cond;
                Field f = path.get(i);
                int index = indices.get(i);
                String par = p;
                if (!p.isEmpty()) {
                    p = p + ".";
                }
                p = p + f.getName();
                if (ReflectionTools.needsIndex((Field)f)) {
                    p = p + "[" + index + "]";
                }
                if ((cond = f.getAnnotation(Conditional.class)) != null) {
                    ConditionEvaluator ev = new ConditionEvaluator(cond);
                    try {
                        Set fieldNames = ev.getFields();
                        HashMap<String, Boolean> fields = new HashMap<String, Boolean>();
                        for (String fld : fieldNames) {
                            String ckey = "";
                            if (!par.isEmpty()) {
                                ckey = par + ".";
                            }
                            if (!this.editors.containsKey(ckey = ckey + fld)) continue;
                            GenericTagEditor editor = this.editors.get(ckey);
                            Object val = editor.getChangedValue();
                            fields.put(fld, true);
                            if (!(val instanceof Boolean)) continue;
                            fields.put(fld, (Boolean)val);
                        }
                        boolean ok = ev.eval(fields);
                        if (conditionMet) {
                            conditionMet = ok;
                        }
                        ((Component)((Object)dependentEditor)).setVisible(conditionMet);
                        dependentLabel.setVisible(conditionMet);
                        dependentTypeLabel.setVisible(conditionMet);
                    }
                    catch (AnnotationParseException ex) {
                        logger.log(Level.SEVERE, "Invalid condition", ex);
                    }
                }
                if (!conditionMet) continue block2;
            }
        }
        this.genericTagPropertiesEditPanel.removeAll();
        this.genericTagPropertiesEditPanel.setSize(0, 0);
        int propCount = 0;
        for (String key : this.keys) {
            Component dependentEditor;
            if (this.addKeys.contains(key)) {
                dependentEditor = this.addButtons.get(key);
            } else if (this.removeButtons.containsKey(key)) {
                JPanel editRemPanel = new JPanel(new BorderLayout());
                editRemPanel.add((Component)((Object)this.editors.get(key)), "Center");
                editRemPanel.add(this.removeButtons.get(key), "East");
                dependentEditor = editRemPanel;
            } else {
                dependentEditor = (Component)((Object)this.editors.get(key));
            }
            Component dependentLabel = this.labels.get(key);
            Component dependentTypeLabel = this.types.get(key);
            if (!dependentEditor.isVisible()) continue;
            this.genericTagPropertiesEditPanel.add(dependentLabel);
            this.genericTagPropertiesEditPanel.add(dependentEditor);
            this.genericTagPropertiesEditPanel.add(dependentTypeLabel);
            ++propCount;
        }
        this.relayout(propCount);
    }
}

