/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.BasicRibbonApplicationMenuButtonUI;

public class JRibbonApplicationMenuButton
extends JCommandButton {
    private JRibbon ribbon;
    public static final String uiClassID = "RibbonApplicationMenuButtonUI";
    static final int APP_BUTTON_SIZE = Integer.getInteger("peacock.appButtonSize", 24);
    private static final CommandButtonDisplayState APP_MENU_BUTTON_STATE = new CommandButtonDisplayState("Ribbon Application Menu Button", APP_BUTTON_SIZE){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManager(){

                @Override
                public int getPreferredIconSize() {
                    return APP_BUTTON_SIZE;
                }

                @Override
                public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
                    CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
                    result.actionClickArea = new Rectangle(0, 0, 0, 0);
                    result.popupClickArea = new Rectangle(0, 0, commandButton.getWidth(), commandButton.getHeight());
                    result.popupActionRect = new Rectangle(0, 0, 0, 0);
                    ResizableIcon icon = commandButton.getIcon();
                    result.iconRect = new Rectangle((commandButton.getWidth() - icon.getIconWidth()) / 2, (commandButton.getHeight() - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight());
                    result.isTextInActionArea = false;
                    return result;
                }

                @Override
                public Dimension getPreferredSize(AbstractCommandButton commandButton) {
                    return new Dimension(40, 40);
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }

                @Override
                public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
                    return new Point(commandButton.getWidth() / 2, commandButton.getHeight() / 2);
                }
            };
        }
    };

    public JRibbonApplicationMenuButton(JRibbon ribbon) {
        super("", new EmptyResizableIcon(16));
        this.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        this.setDisplayState(APP_MENU_BUTTON_STATE);
        this.ribbon = ribbon;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BasicCommandButtonUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicRibbonApplicationMenuButtonUI.createUI(this));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }
}

