/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.gfx.GlyphInfoType;
import com.jpexs.decompiler.flash.types.gfx.GlyphType;
import com.jpexs.decompiler.flash.types.gfx.KerningPairType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FontType
implements Serializable {
    public static final int FF_Italic = 1;
    public static final int FF_Bold = 2;
    public String fontName;
    public int flags;
    public int nominalSize;
    public int ascent;
    public int descent;
    public int leading;
    public List<GlyphType> glyphs;
    public List<GlyphInfoType> glyphInfo;
    public List<KerningPairType> kerning;

    public FontType() {
        this.fontName = "New font";
        this.glyphInfo = new ArrayList<GlyphInfoType>();
        this.kerning = new ArrayList<KerningPairType>();
        this.glyphs = new ArrayList<GlyphType>();
    }

    public FontType(GFxInputStream sis) throws IOException {
        long offset = sis.getPos();
        this.fontName = sis.readString("fontName");
        this.flags = sis.readUI16("flags");
        this.nominalSize = sis.readUI16("nominalSize");
        this.ascent = sis.readSI16("ascent");
        this.descent = sis.readSI16("descent");
        this.leading = sis.readSI16("leading");
        long numGlyphs = sis.readUI32("numGlyphs");
        long glyphBytesLen = sis.readUI32("glyphBytesLen");
        byte[] glyphBytes = new byte[(int)glyphBytesLen];
        sis.read(glyphBytes);
        this.glyphInfo = new ArrayList<GlyphInfoType>();
        int i = 0;
        while ((long)i < numGlyphs) {
            sis.newDumpLevel("glyphInfoType", "GlyphInfoType");
            this.glyphInfo.add(new GlyphInfoType(sis));
            sis.endDumpLevel();
            ++i;
        }
        long kerningTableSize = sis.readUI30("kerningTableSize");
        this.kerning = new ArrayList<KerningPairType>();
        int i2 = 0;
        while ((long)i2 < kerningTableSize) {
            sis.newDumpLevel("kerningPairType", "KerningPairType");
            this.kerning.add(new KerningPairType(sis));
            sis.endDumpLevel();
            ++i2;
        }
        long pos = sis.getPos();
        this.glyphs = new ArrayList<GlyphType>();
        for (int i3 = 0; i3 < this.glyphInfo.size(); ++i3) {
            sis.setPos(this.glyphInfo.get((int)i3).globalOffset + offset);
            sis.newDumpLevel("glyphType", "GlyphType");
            this.glyphs.add(new GlyphType(sis, offset));
            sis.endDumpLevel();
        }
        sis.setPos(pos);
    }

    public List<SHAPE> getGlyphShapes() {
        ArrayList<SHAPE> ret = new ArrayList<SHAPE>();
        for (GlyphType g : this.glyphs) {
            ret.add(g.toSHAPE());
        }
        return ret;
    }

    public void write(GFxOutputStream sos) throws IOException {
        sos = new GFxOutputStream(sos);
        sos.write(this.fontName.getBytes());
        sos.writeUI8(0);
        sos.writeUI16(this.flags);
        sos.writeUI16(this.nominalSize);
        sos.writeUI16(this.ascent);
        sos.writeUI16(this.descent);
        sos.writeUI16(this.leading);
        sos.writeUI32(this.glyphInfo.size());
        long headerLen = sos.getPos() + 4L;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GFxOutputStream sos2 = new GFxOutputStream(baos);
        for (int i = 0; i < this.glyphs.size(); ++i) {
            this.glyphInfo.get((int)i).globalOffset = headerLen + sos2.getPos();
            this.glyphs.get(i).write(sos2);
        }
        byte[] glyphBytes = baos.toByteArray();
        sos.writeUI32(glyphBytes.length);
        sos.write(glyphBytes);
        for (int i = 0; i < this.glyphInfo.size(); ++i) {
            this.glyphInfo.get(i).write(sos);
        }
        sos.writeUI30(this.kerning.size());
        for (KerningPairType kp : this.kerning) {
            kp.write(sos);
        }
    }
}

