/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SWFVersion(from=5)
public class ExportAssetsTag
extends SymbolClassTypeTag {
    public static final int ID = 56;
    public static final String NAME = "ExportAssets";
    @SWFType(value=BasicType.UI16)
    @SWFArray(value="tag", countField="count")
    @Table(value="assets", itemName="asset")
    public List<Integer> tags;
    @SWFArray(value="name", countField="count")
    @Table(value="assets", itemName="asset")
    public List<String> names;

    public ExportAssetsTag(SWF swf) {
        super(swf, 56, NAME, null);
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
    }

    @Override
    public Map<Integer, String> getTagToNameMap() {
        HashMap<Integer, String> exportNames = new HashMap<Integer, String>();
        for (int i = 0; i < this.tags.size(); ++i) {
            int tagId = this.tags.get(i);
            String name = this.names.get(i);
            if (exportNames.containsKey(tagId) || exportNames.containsValue(name)) continue;
            exportNames.put(tagId, name);
        }
        return exportNames;
    }

    public ExportAssetsTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 56, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        int count = sis.readUI16("count");
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            int characterId = sis.readUI16("characterId");
            String name = sis.readString("name");
            this.tags.add(characterId);
            this.names.add(name);
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.tags.size());
        for (int i = 0; i < this.tags.size(); ++i) {
            sos.writeUI16(this.tags.get(i));
            sos.writeString(this.names.get(i));
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i) != oldCharacterId) continue;
            this.tags.set(i, newCharacterId);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i) != characterId) continue;
            this.tags.remove(i);
            this.names.remove(i);
            --i;
            modified = true;
        }
        return modified;
    }
}

