/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.Set;

@SWFVersion(from=6)
public class DefineVideoStreamTag
extends CharacterTag
implements BoundedTag {
    public static final int ID = 60;
    public static final String NAME = "DefineVideoStream";
    @SWFType(value=BasicType.UI16)
    public int characterID;
    @SWFType(value=BasicType.UI16)
    public int numFrames;
    @SWFType(value=BasicType.UI16)
    public int width;
    @SWFType(value=BasicType.UI16)
    public int height;
    @Reserved
    @SWFType(value=BasicType.UB, count=4)
    public int reserved;
    @SWFType(value=BasicType.UB, count=3)
    public int videoFlagsDeblocking;
    public boolean videoFlagsSmoothing;
    @SWFType(value=BasicType.UI8)
    public int codecID;
    public static final int CODEC_SORENSON_H263 = 2;
    public static final int CODEC_SCREEN_VIDEO = 3;
    public static final int CODEC_VP6 = 4;
    public static final int CODEC_VP6_ALPHA = 5;

    public DefineVideoStreamTag(SWF swf) {
        super(swf, 60, NAME, null);
        this.characterID = swf.getNextCharacterId();
    }

    public DefineVideoStreamTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 60, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.numFrames = sis.readUI16("numFrames");
        this.width = sis.readUI16("width");
        this.height = sis.readUI16("height");
        this.reserved = (int)sis.readUB(4, "reserved");
        this.videoFlagsDeblocking = (int)sis.readUB(3, "videoFlagsDeblocking");
        this.videoFlagsSmoothing = sis.readUB(1, "videoFlagsSmoothing") == 1L;
        this.codecID = sis.readUI8("codecID");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI16(this.numFrames);
        sos.writeUI16(this.width);
        sos.writeUI16(this.height);
        sos.writeUB(4, this.reserved);
        sos.writeUB(3, this.videoFlagsDeblocking);
        sos.writeUB(1, this.videoFlagsSmoothing ? 1L : 0L);
        sos.writeUI8(this.codecID);
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return new RECT(0, (int)(20.0 * (double)this.width), 0, (int)(20.0 * (double)this.height));
    }
}

