/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ShapeImporter {
    public Tag importImage(ShapeTag st, byte[] newData) throws IOException {
        return this.importImage(st, newData, 0, true);
    }

    public Tag importImage(ShapeTag st, byte[] newData, int tagType, boolean fill) throws IOException {
        SHAPEWITHSTYLE shapes;
        ImageTag imageTag = this.addImage(st, newData, tagType);
        st.setModified(true);
        RECT rect = st.getRect();
        if (!fill) {
            Dimension dimension = imageTag.getImageDimension();
            rect.Xmax = rect.Xmin + (int)(20.0 * dimension.getWidth());
            rect.Ymax = rect.Ymin + (int)(20.0 * dimension.getHeight());
        }
        st.shapes = shapes = imageTag.getShape(rect, fill);
        return st;
    }

    public ImageTag addImage(Tag st, byte[] newData, int tagType) throws IOException {
        ImageTag imageTag;
        SWF swf = st.getSwf();
        if (newData[0] == 66 && newData[1] == 77) {
            BufferedImage b = ImageHelper.read(newData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageHelper.write(b, ImageFormat.PNG, baos);
            newData = baos.toByteArray();
        }
        if (tagType == 0) {
            tagType = ImageTag.getImageFormat(newData) == ImageFormat.JPEG ? 21 : 36;
        }
        switch (tagType) {
            case 21: {
                imageTag = new DefineBitsJPEG2Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 35: {
                imageTag = new DefineBitsJPEG3Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 90: {
                imageTag = new DefineBitsJPEG4Tag(swf, null, swf.getNextCharacterId(), newData);
                break;
            }
            case 20: {
                DefineBitsLosslessTag losslessTag = new DefineBitsLosslessTag(swf);
                losslessTag.setImage(newData);
                imageTag = losslessTag;
                break;
            }
            case 36: {
                DefineBitsLossless2Tag lossless2Tag = new DefineBitsLossless2Tag(swf);
                lossless2Tag.setImage(newData);
                imageTag = lossless2Tag;
                break;
            }
            default: {
                throw new Error("Unsupported image type tag.");
            }
        }
        swf.addTag(imageTag, (TreeItem)st);
        swf.updateCharacters();
        return imageTag;
    }

    public static int getShapeTagType(String format) {
        int res = 0;
        switch (format) {
            case "shape": {
                res = 2;
                break;
            }
            case "shape2": {
                res = 22;
                break;
            }
            case "shape3": {
                res = 32;
                break;
            }
            case "shape4": {
                res = 83;
            }
        }
        return res;
    }
}

