/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;

public class BitmapExporter
extends ShapeExporterBase {
    private static final Point POINT_NEG16384_0 = new Point(-16384, 0);
    private static final Point POINT_16384_0 = new Point(16384, 0);
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private SerializableImage image;
    private Graphics2D graphics;
    private final Color defaultColor;
    private final SWF swf;
    private final GeneralPath path = new GeneralPath(0);
    private Paint fillPaint;
    private AffineTransform fillTransform;
    private Paint linePaint;
    private AffineTransform lineTransform;
    private Color lineColor;
    private Stroke lineStroke;
    private Stroke defaultStroke;
    private Matrix strokeTransformation;

    public static void export(SWF swf, SHAPE shape, Color defaultColor, SerializableImage image, Matrix transformation, Matrix strokeTransformation, ColorTransform colorTransform) {
        BitmapExporter exporter = new BitmapExporter(swf, shape, defaultColor, colorTransform);
        exporter.exportTo(image, transformation, strokeTransformation);
    }

    private BitmapExporter(SWF swf, SHAPE shape, Color defaultColor, ColorTransform colorTransform) {
        super(swf, shape, colorTransform);
        this.swf = swf;
        this.defaultColor = defaultColor;
    }

    private void exportTo(SerializableImage image, Matrix transformation, Matrix strokeTransformation) {
        this.image = image;
        this.strokeTransformation = strokeTransformation.clone();
        this.strokeTransformation.scaleX /= 20.0;
        this.strokeTransformation.scaleY /= 20.0;
        this.graphics = (Graphics2D)image.getGraphics();
        AffineTransform at = transformation.toTransform();
        at.preConcatenate(AffineTransform.getScaleInstance(0.05, 0.05));
        this.graphics.setTransform(at);
        this.defaultStroke = this.graphics.getStroke();
        super.export();
    }

    public SerializableImage getImage() {
        return this.image;
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        if (close) {
            this.path.closePath();
        }
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color) {
        this.finalizePath();
        this.fillPaint = color == null ? this.defaultColor : color.toColor();
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
        MultipleGradientPaint.ColorSpaceType cstype = MultipleGradientPaint.ColorSpaceType.SRGB;
        if (interpolationMethod == 1) {
            cstype = MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        }
        switch (type) {
            case 16: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.fillPaint = new LinearGradientPaint(POINT_NEG16384_0, POINT_16384_0, ratiosArr, colorsArr, cm, cstype, IDENTITY_TRANSFORM);
                this.fillTransform = matrix.toTransform();
                break;
            }
            case 18: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.fillPaint = new RadialGradientPaint(new Point(0, 0), 16384.0f, ratiosArr, colorsArr, cm);
                this.fillTransform = matrix.toTransform();
                break;
            }
            case 19: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.fillPaint = new RadialGradientPaint(new Point(0, 0), 16384.0f, new Point((int)(focalPointRatio * 16384.0f), 0), ratiosArr, colorsArr, cm, cstype, AffineTransform.getTranslateInstance(0.0, 0.0));
                this.fillTransform = matrix.toTransform();
            }
        }
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        this.finalizePath();
        ImageTag imageTag = this.swf.getImage(bitmapId);
        if (imageTag != null && (img = imageTag.getImageCached()) != null) {
            if (colorTransform != null) {
                img = colorTransform.apply(img);
            }
            this.fillPaint = new TexturePaint(img.getBufferedImage(), new Rectangle(img.getWidth(), img.getHeight()));
            this.fillTransform = matrix.toTransform();
            return;
        }
        this.fillPaint = Color.RED;
        this.fillTransform = matrix.toTransform();
    }

    @Override
    public void endFill() {
        this.finalizePath();
        this.fillPaint = null;
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        this.linePaint = null;
        this.lineTransform = null;
        this.lineColor = color == null ? null : color.toColor();
        int capStyle = 1;
        switch (startCaps) {
            case 1: {
                capStyle = 0;
                break;
            }
            case 0: {
                capStyle = 1;
                break;
            }
            case 2: {
                capStyle = 2;
            }
        }
        int joinStyle = 1;
        switch (joints) {
            case 1: {
                joinStyle = 2;
                break;
            }
            case 2: {
                joinStyle = 0;
                break;
            }
            case 0: {
                joinStyle = 1;
            }
        }
        switch (scaleMode) {
            case "VERTICAL": {
                thickness *= this.strokeTransformation.scaleY;
                break;
            }
            case "HORIZONTAL": {
                thickness *= this.strokeTransformation.scaleX;
                break;
            }
            case "NORMAL": {
                thickness *= Math.max(this.strokeTransformation.scaleX, this.strokeTransformation.scaleY);
            }
        }
        if (thickness < 0.0) {
            thickness = -thickness;
        }
        this.lineStroke = joinStyle == 0 ? new BasicStroke((float)thickness, capStyle, joinStyle, miterLimit) : new BasicStroke((float)thickness, capStyle, joinStyle);
        try {
            AffineTransform t = (AffineTransform)this.graphics.getTransform().clone();
            t.translate(-0.5, -0.5);
            this.lineStroke = new TransformedStroke(this.lineStroke, t);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        MultipleGradientPaint.ColorSpaceType cstype = MultipleGradientPaint.ColorSpaceType.SRGB;
        if (interpolationMethod == 1) {
            cstype = MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
        }
        switch (type) {
            case 16: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.linePaint = new LinearGradientPaint(POINT_NEG16384_0, POINT_16384_0, ratiosArr, colorsArr, cm, cstype, IDENTITY_TRANSFORM);
                this.lineTransform = matrix.toTransform();
                break;
            }
            case 18: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                switch (spreadMethod) {
                    case 0: {
                        cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                        break;
                    }
                    case 1: {
                        cm = MultipleGradientPaint.CycleMethod.REFLECT;
                        break;
                    }
                    case 2: {
                        cm = MultipleGradientPaint.CycleMethod.REPEAT;
                    }
                }
                this.linePaint = new RadialGradientPaint(new Point(0, 0), 16384.0f, ratiosArr, colorsArr, cm);
                this.lineTransform = matrix.toTransform();
                break;
            }
            case 19: {
                ArrayList<Color> colors = new ArrayList<Color>();
                ArrayList<Float> ratios = new ArrayList<Float>();
                for (int i = 0; i < gradientRecords.length; ++i) {
                    if (i > 0 && gradientRecords[i - 1].ratio == gradientRecords[i].ratio) continue;
                    ratios.add(Float.valueOf(gradientRecords[i].getRatioFloat()));
                    colors.add(gradientRecords[i].color.toColor());
                }
                float[] ratiosArr = new float[ratios.size()];
                for (int i = 0; i < ratios.size(); ++i) {
                    ratiosArr[i] = ((Float)ratios.get(i)).floatValue();
                }
                Color[] colorsArr = colors.toArray(new Color[colors.size()]);
                MultipleGradientPaint.CycleMethod cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (spreadMethod == 0) {
                    cm = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                } else if (spreadMethod == 1) {
                    cm = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (spreadMethod == 2) {
                    cm = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                this.linePaint = new RadialGradientPaint(new Point(0, 0), 16384.0f, new Point((int)(focalPointRatio * 16384.0f), 0), ratiosArr, colorsArr, cm, cstype, AffineTransform.getTranslateInstance(0.0, 0.0));
                this.lineTransform = matrix.toTransform();
            }
        }
    }

    @Override
    public void moveTo(double x, double y) {
        this.path.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.path.lineTo(x, y);
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        this.path.quadTo(controlX, controlY, anchorX, anchorY);
    }

    protected void finalizePath() {
        if (this.fillPaint != null) {
            double minY;
            double minX;
            double shx;
            double scy;
            Matrix inverse;
            AffineTransform oldAf;
            this.graphics.setComposite(AlphaComposite.SrcOver);
            if (this.fillPaint instanceof MultipleGradientPaint) {
                oldAf = this.graphics.getTransform();
                this.graphics.setClip(this.path);
                inverse = null;
                try {
                    double scx = this.fillTransform.getScaleX();
                    scy = this.fillTransform.getScaleY();
                    shx = this.fillTransform.getShearX();
                    double shy = this.fillTransform.getShearY();
                    double det = scx * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.fillTransform.setToTranslation(this.fillTransform.getTranslateX(), this.fillTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.fillTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx) {
                    // empty catch block
                }
                this.fillTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.fillTransform);
                this.graphics.setPaint(this.fillPaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(this.path.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(null);
            } else if (this.fillPaint instanceof TexturePaint) {
                oldAf = this.graphics.getTransform();
                this.graphics.setClip(this.path);
                inverse = null;
                try {
                    double scx = this.fillTransform.getScaleX();
                    scy = this.fillTransform.getScaleY();
                    shx = this.fillTransform.getShearX();
                    double shy = this.fillTransform.getShearY();
                    double det = scx * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.fillTransform.setToTranslation(this.fillTransform.getTranslateX(), this.fillTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.fillTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx) {
                    // empty catch block
                }
                this.fillTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.fillTransform);
                this.graphics.setPaint(this.fillPaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(this.path.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(null);
            } else {
                this.graphics.setPaint(this.fillPaint);
                this.graphics.fill(this.path);
            }
        }
        if (this.linePaint != null && this.lineStroke != null) {
            double minY;
            double minX;
            double scy;
            double scx2;
            AffineTransform oldAf;
            Shape strokedShape = this.lineStroke.createStrokedShape(this.path);
            this.graphics.setComposite(AlphaComposite.SrcOver);
            if (this.linePaint instanceof MultipleGradientPaint) {
                oldAf = this.graphics.getTransform();
                this.graphics.setClip(strokedShape);
                Matrix inverse = null;
                try {
                    scx2 = this.lineTransform.getScaleX();
                    scy = this.lineTransform.getScaleY();
                    double shx = this.lineTransform.getShearX();
                    double shy = this.lineTransform.getShearY();
                    double det = scx2 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.lineTransform.setToTranslation(this.lineTransform.getTranslateX(), this.lineTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.lineTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx2) {
                    // empty catch block
                }
                this.lineTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.lineTransform);
                this.graphics.setPaint(this.linePaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(strokedShape.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(null);
            } else if (this.linePaint instanceof TexturePaint) {
                oldAf = this.graphics.getTransform();
                this.graphics.setClip(strokedShape);
                Matrix inverse = null;
                try {
                    scx2 = this.lineTransform.getScaleX();
                    scy = this.lineTransform.getScaleY();
                    double shx = this.lineTransform.getShearX();
                    double shy = this.lineTransform.getShearY();
                    double det = scx2 * scy - shx * shy;
                    if (Math.abs(det) <= Double.MIN_VALUE) {
                        this.lineTransform.setToTranslation(this.lineTransform.getTranslateX(), this.lineTransform.getTranslateY());
                    }
                    inverse = new Matrix(new AffineTransform(this.lineTransform).createInverse());
                }
                catch (NoninvertibleTransformException scx3) {
                    // empty catch block
                }
                this.lineTransform.preConcatenate(oldAf);
                this.graphics.setTransform(this.lineTransform);
                this.graphics.setPaint(this.linePaint);
                if (inverse != null) {
                    ExportRectangle rect = inverse.transform(new ExportRectangle(this.path.getBounds2D()));
                    minX = rect.xMin;
                    minY = rect.yMin;
                    this.graphics.fill(new Rectangle((int)minX, (int)minY, (int)(rect.xMax - minX), (int)(rect.yMax - minY)));
                }
                this.graphics.setTransform(oldAf);
                this.graphics.setClip(null);
            } else {
                this.graphics.setPaint(this.linePaint);
                this.graphics.fill(strokedShape);
            }
        } else if (this.lineColor != null) {
            this.graphics.setColor(this.lineColor);
            this.graphics.setStroke(this.lineStroke == null ? this.defaultStroke : this.lineStroke);
            this.graphics.draw(this.path);
        }
        this.path.reset();
        this.lineStroke = null;
        this.lineColor = null;
        this.fillPaint = null;
    }

    private class TransformedStroke
    implements Stroke {
        private static final long serialVersionUID = 1L;
        private final AffineTransform transform;
        private final AffineTransform inverse;
        private final Stroke stroke;

        public TransformedStroke(Stroke base, AffineTransform at) throws NoninvertibleTransformException {
            this.transform = new AffineTransform(at);
            this.inverse = this.transform.createInverse();
            this.stroke = base;
        }

        @Override
        public Shape createStrokedShape(Shape s) {
            Shape sTrans = this.transform.createTransformedShape(s);
            Shape sTransStroked = this.stroke.createStrokedShape(sTrans);
            Shape sStroked = this.inverse.createTransformedShape(sTransStroked);
            return sStroked;
        }
    }
}

