/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.amf.amf3;

import com.jpexs.decompiler.flash.amf.amf3.WithSubValues;
import com.jpexs.decompiler.flash.amf.amf3.types.AbstractVectorType;
import com.jpexs.decompiler.flash.amf.amf3.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf3.types.ByteArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.DateType;
import com.jpexs.decompiler.flash.amf.amf3.types.DictionaryType;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlDocType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlType;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.helpers.Helper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class Amf3Exporter {
    public static String amfToString(Object amfValue) {
        return Amf3Exporter.amfToString(amfValue, "  ", "\r\n");
    }

    public static String amfToString(Object amfValue, String indentStr, String newLine) {
        HashMap<Object, Integer> refCount = new HashMap<Object, Integer>();
        ArrayList<Object> objectList = new ArrayList<Object>();
        HashMap<Object, String> objectAlias = new HashMap<Object, String>();
        Amf3Exporter.populateObjects(amfValue, refCount, objectList, objectAlias);
        return Amf3Exporter.amfToString(indentStr, newLine, new ArrayList<Object>(), 0, amfValue, refCount, objectAlias);
    }

    public static void populateObjects(Object object, Map<Object, Integer> referenceCount, List<Object> objectList, Map<Object, String> objectAlias) {
        if (Arrays.asList(String.class, Long.class, Double.class, BasicType.class, Boolean.class).contains(object.getClass())) {
            return;
        }
        if (object instanceof BasicType) {
            return;
        }
        int prevRef = 0;
        if (referenceCount.containsKey(object)) {
            prevRef = referenceCount.get(object);
        }
        referenceCount.put(object, prevRef + 1);
        if (prevRef == 0) {
            if (object instanceof WithSubValues) {
                List<Object> subvalues = ((WithSubValues)object).getSubValues();
                for (Object o : subvalues) {
                    Amf3Exporter.populateObjects(o, referenceCount, objectList, objectAlias);
                }
            }
            objectList.add(object);
            objectAlias.put(object, "obj" + objectList.size());
        }
    }

    private static String indent(int level) {
        String na = "";
        for (int i = 0; i < level; ++i) {
            na = na + "  ";
        }
        return na;
    }

    private static String amfToString(String indentStr, String newLine, List<Object> processedObjects, int level, Object object, Map<Object, Integer> referenceCount, Map<Object, String> objectAlias) {
        String addId;
        if (object instanceof String) {
            return "\"" + Helper.escapeActionScriptString((String)object) + "\"";
        }
        if (Arrays.asList(Long.class, Double.class, Boolean.class).contains(object.getClass())) {
            return EcmaScript.toString(object);
        }
        if (object instanceof BasicType) {
            return object.toString();
        }
        StringBuilder ret = new StringBuilder();
        Integer refCount = referenceCount.get(object);
        if (refCount > 1 && processedObjects.contains(object)) {
            ret.append("#").append(objectAlias.get(object));
            return ret.toString();
        }
        processedObjects.add(object);
        String string = addId = refCount > 1 ? Amf3Exporter.indent(level + 1) + "\"id\": \"" + objectAlias.get(object) + "\"," + newLine : "";
        if (object instanceof AbstractVectorType) {
            AbstractVectorType avt = (AbstractVectorType)object;
            ret.append("{").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"type\": \"Vector\",").append(newLine);
            ret.append(addId);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"fixed\": ").append(avt.isFixed()).append(",").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"subtype\": ").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level, avt.getTypeName(), referenceCount, objectAlias)).append(",").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"values\": [");
            for (int i = 0; i < avt.getValues().size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, avt.getValues().get(i), referenceCount, objectAlias));
            }
            ret.append("]").append(newLine);
            ret.append(Amf3Exporter.indent(level)).append("}");
        } else if (object instanceof ObjectType) {
            ObjectType ot = (ObjectType)object;
            ret.append("{").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"type\": \"Object\",").append(newLine);
            ret.append(addId);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"className\": ").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level, ot.getClassName(), referenceCount, objectAlias)).append(",").append(newLine);
            if (ot.isSerialized()) {
                byte[] serData = ot.getSerializedData();
                if (serData == null) {
                    ret.append(Amf3Exporter.indent(level + 1)).append("\"serialized\": unknown").append(newLine);
                } else {
                    ret.append(Amf3Exporter.indent(level + 1)).append("\"serialized\": \"").append(DatatypeConverter.printHexBinary((byte[])serData)).append("\",").append(newLine);
                    if (!ot.getSerializedMembers().isEmpty()) {
                        ret.append(Amf3Exporter.indent(level + 1)).append("\"unserializedMembers\": {").append(newLine);
                        int i = 0;
                        for (String key : ot.sealedMembersKeySet()) {
                            Object val = ot.getSealedMember(key);
                            ret.append(Amf3Exporter.indent(level + 2)).append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 2, key, referenceCount, objectAlias)).append(":").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, val, referenceCount, objectAlias));
                            if (i < ot.serializedMembersSize() - 1) {
                                ret.append(",").append(newLine);
                            } else {
                                ret.append(newLine);
                            }
                            ++i;
                        }
                        ret.append(Amf3Exporter.indent(level + 1)).append("}");
                        ret.append(newLine);
                    }
                }
            } else {
                Object val;
                ret.append(Amf3Exporter.indent(level + 1)).append("\"dynamic\": ").append(ot.isDynamic()).append(",").append(newLine);
                ret.append(Amf3Exporter.indent(level + 1)).append("\"sealedMembers\": {").append(newLine);
                int i = 0;
                for (String key : ot.sealedMembersKeySet()) {
                    val = ot.getSealedMember(key);
                    ret.append(Amf3Exporter.indent(level + 2)).append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 2, key, referenceCount, objectAlias)).append(":").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, val, referenceCount, objectAlias));
                    if (i < ot.sealedMembersSize() - 1) {
                        ret.append(",").append(newLine);
                    } else {
                        ret.append(newLine);
                    }
                    ++i;
                }
                ret.append(Amf3Exporter.indent(level + 1)).append("}");
                ret.append(",");
                ret.append(newLine);
                ret.append(Amf3Exporter.indent(level + 1)).append("\"dynamicMembers\": {").append(newLine);
                i = 0;
                for (String key : ot.dynamicMembersKeySet()) {
                    val = ot.getDynamicMember(key);
                    ret.append(Amf3Exporter.indent(level + 2)).append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 2, key, referenceCount, objectAlias));
                    ret.append(":");
                    ret.append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 2, val, referenceCount, objectAlias));
                    if (i < ot.dynamicMembersSize() - 1) {
                        ret.append(",");
                    }
                    ret.append(newLine);
                    ++i;
                }
                ret.append(Amf3Exporter.indent(level + 1)).append("}").append(newLine);
            }
            ret.append(Amf3Exporter.indent(level)).append("}");
        } else if (object instanceof ArrayType) {
            int i;
            ArrayType at = (ArrayType)object;
            ret.append("{").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"type\": \"Array\",").append(newLine);
            ret.append(addId);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"denseValues\": [");
            for (i = 0; i < at.getDenseValues().size(); ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 2, at.getDenseValues().get(i), referenceCount, objectAlias));
            }
            ret.append("],").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"associativeValues\": {");
            if (!at.getAssociativeValues().isEmpty()) {
                ret.append(newLine);
            }
            i = 0;
            for (String key : at.associativeKeySet()) {
                Object val = at.getAssociative(key);
                ret.append(Amf3Exporter.indent(level + 2)).append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, key, referenceCount, objectAlias)).append(" : ").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, val, referenceCount, objectAlias));
                if (i < at.getAssociativeValues().size() - 1) {
                    ret.append(",");
                }
                ret.append(newLine);
                ++i;
            }
            if (!at.getAssociativeValues().isEmpty()) {
                ret.append(Amf3Exporter.indent(level + 1));
            }
            ret.append("}").append(newLine);
            ret.append(Amf3Exporter.indent(level)).append("}");
        } else if (object instanceof DictionaryType) {
            DictionaryType dt = (DictionaryType)object;
            ret.append("{").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"type\": \"Dictionary\",").append(newLine);
            ret.append(addId);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"weakKeys\": ").append(dt.hasWeakKeys()).append(",").append(newLine);
            ret.append(Amf3Exporter.indent(level + 1)).append("\"entries\": {").append(newLine);
            int i = 0;
            for (Object key : dt.keySet()) {
                Object val = dt.get(key);
                ret.append(Amf3Exporter.indent(level + 1)).append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, key, referenceCount, objectAlias)).append(" : ").append(Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level + 1, val, referenceCount, objectAlias));
                if (i < dt.size() - 1) {
                    ret.append(",");
                }
                ret.append(newLine);
                ++i;
            }
            ret.append(Amf3Exporter.indent(level + 1)).append("}").append(newLine);
            ret.append(Amf3Exporter.indent(level)).append("}");
        } else {
            if (object instanceof ByteArrayType) {
                ByteArrayType ba = (ByteArrayType)object;
                byte[] data = ba.getData();
                return "{" + newLine + Amf3Exporter.indent(level + 1) + "\"type\": \"ByteArray\"," + newLine + addId + Amf3Exporter.indent(level + 1) + "\"value\": \"" + DatatypeConverter.printHexBinary((byte[])data) + "\"" + newLine + Amf3Exporter.indent(level) + "}";
            }
            if (object instanceof DateType) {
                DateType dt = (DateType)object;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
                return "{" + newLine + Amf3Exporter.indent(level + 1) + "\"type\": \"Date\"," + newLine + addId + Amf3Exporter.indent(level + 1) + "\"value\": " + Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level, sdf.format(new Date((long)dt.getVal())), referenceCount, objectAlias) + newLine + Amf3Exporter.indent(level) + "}";
            }
            if (object instanceof XmlDocType) {
                return "{" + newLine + Amf3Exporter.indent(level + 1) + "\"type\": \"XMLDocument\"," + newLine + addId + Amf3Exporter.indent(level + 1) + "\"value\": " + Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level, ((XmlDocType)object).getData(), referenceCount, objectAlias) + newLine + Amf3Exporter.indent(level) + "}";
            }
            if (object instanceof XmlType) {
                return "{" + newLine + Amf3Exporter.indent(level + 1) + "\"type\": \"XML\"," + newLine + addId + Amf3Exporter.indent(level + 1) + "\"value\": " + Amf3Exporter.amfToString(indentStr, newLine, processedObjects, level, ((XmlType)object).getData(), referenceCount, objectAlias) + newLine + Amf3Exporter.indent(level) + "}";
            }
            throw new IllegalArgumentException("Unsupported type: " + object.getClass());
        }
        return ret.toString();
    }
}

