/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf3;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.amf.amf3.ListMap;
import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.amf.amf3.ObjectTypeSerializeHandler;
import com.jpexs.decompiler.flash.amf.amf3.Traits;
import com.jpexs.decompiler.flash.amf.amf3.UnsupportedValueTypeException;
import com.jpexs.decompiler.flash.amf.amf3.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf3.types.ByteArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.DateType;
import com.jpexs.decompiler.flash.amf.amf3.types.DictionaryType;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorDoubleType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorUIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlDocType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlType;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Amf3InputStream
extends InputStream {
    public static final Logger LOGGER = Logger.getLogger(Amf3InputStream.class.getName());
    private final MemoryInputStream is;
    public DumpInfo dumpInfo;
    private static final String NO_REFERENCE_BIT_TEXT = "not reference";
    private static final String OBJECT_INDEX_TEXT = "object index";
    private static final String STRING_INDEX_TEXT = "string index";
    private static final String TRAIT_INDEX_TEXT = "trait index";

    public Amf3InputStream(MemoryInputStream is) {
        this.is = is;
    }

    public DumpInfo newDumpLevel(String name, String type) {
        if (this.dumpInfo != null) {
            long startByte = this.is.getPos();
            DumpInfo di = new DumpInfo(name, type, null, startByte, 0, 0L, 0);
            di.parent = this.dumpInfo;
            this.dumpInfo.getChildInfos().add(di);
            this.dumpInfo = di;
        }
        return this.dumpInfo;
    }

    public void endDumpLevel() {
        this.endDumpLevel(null);
    }

    public void endDumpLevel(Object value) {
        if (this.dumpInfo != null) {
            this.dumpInfo.lengthBytes = this.is.getPos() - this.dumpInfo.startByte;
            this.dumpInfo.previewValue = value;
            this.dumpInfo = this.dumpInfo.parent;
        }
    }

    public void endDumpLevelUntil(DumpInfo di) {
        if (di != null) {
            while (this.dumpInfo != null && this.dumpInfo != di) {
                this.endDumpLevel();
            }
        }
    }

    public int readU8(String name) throws IOException {
        this.newDumpLevel(name, "U8");
        int ret = this.readInternal();
        this.endDumpLevel(ret);
        return ret;
    }

    public int readU16(String name) throws IOException {
        this.newDumpLevel(name, "U16");
        int b1 = this.readInternal();
        int b2 = this.readInternal();
        int ret = (b1 << 8) + b2;
        this.endDumpLevel(ret);
        return ret;
    }

    public long readU32(String name) throws IOException {
        this.newDumpLevel(name, "U32");
        long ret = this.readU32Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    private long readU32Internal() throws IOException {
        int b1 = this.readInternal();
        int b2 = this.readInternal();
        int b3 = this.readInternal();
        int b4 = this.readInternal();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4 & 0xFFFFFFFF;
    }

    public long readS32(String name) throws IOException {
        this.newDumpLevel(name, "S32");
        long ret = this.signExtend(this.readU32Internal(), 32);
        this.endDumpLevel(ret);
        return ret;
    }

    private long readLong() throws IOException {
        byte[] readBuffer = new byte[8];
        for (int i = 0; i < 8; ++i) {
            readBuffer[i] = (byte)this.readInternal();
        }
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)(readBuffer[7] & 0xFF);
    }

    public double readDouble(String name) throws IOException {
        this.newDumpLevel(name, "DOUBLE");
        long lval = this.readLong();
        double ret = Double.longBitsToDouble(lval);
        this.endDumpLevel(EcmaScript.toString(ret));
        return ret;
    }

    public long readU29(String name) throws IOException {
        this.newDumpLevel(name, "U29");
        long val = this.readU29Internal();
        this.endDumpLevel(val);
        return val;
    }

    private void renameU29O_ref() {
        this.renameU29("U29O-ref", NO_REFERENCE_BIT_TEXT, OBJECT_INDEX_TEXT);
    }

    private void renameU29S_ref() {
        this.renameU29("U29S-ref", NO_REFERENCE_BIT_TEXT, STRING_INDEX_TEXT);
    }

    private void renameU29Traits_ref() {
        this.renameU29("U29O-traits-ref", NO_REFERENCE_BIT_TEXT, "trait reference", TRAIT_INDEX_TEXT);
    }

    private void renameLastDump(String wholeName) {
        if (this.dumpInfo != null && !this.dumpInfo.getChildInfos().isEmpty()) {
            DumpInfo u29DumpInfo = this.dumpInfo.getChildInfos().get(this.dumpInfo.getChildInfos().size() - 1);
            u29DumpInfo.name = wholeName;
        }
    }

    private void setDumpInfoType(String type) {
        if (this.dumpInfo != null) {
            this.dumpInfo.type = type;
        }
    }

    private void renameU29(String wholeName, String name1, String ... names) {
        ArrayList<String> bitNames = new ArrayList<String>();
        bitNames.add(name1);
        bitNames.addAll(Arrays.asList(names));
        String restName = (String)bitNames.remove(bitNames.size() - 1);
        if (bitNames.size() > 6) {
            throw new RuntimeException("Renaming more than 6 bits in U29 is not supported");
        }
        if (this.dumpInfo != null && !this.dumpInfo.getChildInfos().isEmpty()) {
            DumpInfo u29DumpInfo = this.dumpInfo.getChildInfos().get(this.dumpInfo.getChildInfos().size() - 1);
            u29DumpInfo.name = wholeName;
            long lastBytePos = u29DumpInfo.startByte + u29DumpInfo.lengthBytes - 1L;
            int remainingBitLength = (int)u29DumpInfo.lengthBytes * 8 - bitNames.size();
            long u29val = (Long)u29DumpInfo.previewValue;
            DumpInfo restDumpInfo = new DumpInfo(restName, "UB(" + remainingBitLength + ")", u29val >> bitNames.size(), lastBytePos, 0, u29DumpInfo.lengthBytes, remainingBitLength);
            restDumpInfo.parent = u29DumpInfo;
            u29DumpInfo.getChildInfos().add(restDumpInfo);
            for (int i = bitNames.size() - 1; i >= 0; --i) {
                int bitVal = (int)(u29val >> i & 1L);
                DumpInfo bitDumpInfo = new DumpInfo((String)bitNames.get(i), "bit", bitVal, lastBytePos, 7 - i, 1L, 1);
                bitDumpInfo.parent = u29DumpInfo;
                u29DumpInfo.getChildInfos().add(bitDumpInfo);
            }
        }
    }

    public long readS29(String name) throws IOException {
        this.newDumpLevel(name, "S29");
        long val = this.signExtend(this.readU29Internal(), 29);
        this.endDumpLevel(val);
        return val;
    }

    public long readU29Internal() throws IOException {
        long val = 0L;
        for (int i = 1; i <= 4; ++i) {
            int b = this.readInternal();
            if (i == 4) {
                val = (val << 8) + (long)b;
                continue;
            }
            val = (val << 7) + (long)(b & 0x7F);
            if ((b & 0x80) != 128) break;
        }
        return val;
    }

    private long signExtend(long val, int size) {
        if ((val >> size - 1 & 1L) == 1L) {
            long mask = size == 32 ? -1L : (long)((1 << size) - 1);
            long positiveVal = (val - 1L ^ 0xFFFFFFFFFFFFFFFFL) & mask;
            long negativeVal = -positiveVal;
            return negativeVal;
        }
        return val;
    }

    private String readUtf8Char(String name, long byteLength) throws IOException {
        if (byteLength == 0L) {
            return "";
        }
        this.newDumpLevel(name, "UTF8-char");
        byte[] buf = new byte[(int)byteLength];
        int cnt = this.is.read(buf);
        if (cnt < buf.length) {
            throw new EndOfStreamException();
        }
        String retString = new String(buf, "UTF-8");
        this.endDumpLevel("\"" + Helper.escapeActionScriptString(retString) + "\"");
        return retString;
    }

    public String readUtf8Vr(String name, List<String> stringTable) throws IOException {
        String retString;
        this.newDumpLevel(name, "UTF-8-vr");
        long u = this.readU29("U29S");
        int stringNoRefFlag = (int)(u & 1L);
        if (stringNoRefFlag == 1) {
            this.renameU29("U29S-value", NO_REFERENCE_BIT_TEXT, "byte length");
            long byteLength = u >> 1;
            retString = this.readUtf8Char("characters", byteLength);
            if (byteLength > 0L) {
                stringTable.add(retString);
            }
            LOGGER.log(Level.FINE, "Read string: \"{0}\"", retString);
        } else {
            this.renameU29S_ref();
            int stringRefTableIndex = (int)(u >> 1);
            retString = stringTable.get(stringRefTableIndex);
            LOGGER.log(Level.FINE, "Read string: reference({0}):" + retString, stringRefTableIndex);
        }
        this.endDumpLevel("\"" + Helper.escapeActionScriptString(retString) + "\"");
        return retString;
    }

    private int readInternal() throws IOException {
        int ret = this.read();
        if (ret == -1) {
            throw new EndOfStreamException();
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    public Object readValue(String name) throws IOException, NoSerializerExistsException {
        return this.readValue(name, new HashMap<String, ObjectTypeSerializeHandler>());
    }

    public Object readValue(String name, Map<String, ObjectTypeSerializeHandler> serializers) throws IOException, NoSerializerExistsException {
        return this.readValue(name, serializers, new ArrayList<Object>(), new ArrayList<Traits>(), new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readValue(String name, Map<String, ObjectTypeSerializeHandler> serializers, List<Object> objectTable, List<Traits> traitsTable, List<String> stringTable) throws IOException, NoSerializerExistsException {
        this.newDumpLevel(name, "value-type");
        try {
            int marker = this.readU8("marker");
            switch (marker) {
                case 0: {
                    this.renameLastDump("undefined-marker");
                    this.setDumpInfoType("undefined-type");
                    LOGGER.log(Level.FINE, "Read value: undefined");
                    Object result = BasicType.UNDEFINED;
                    return result;
                }
                case 1: {
                    this.renameLastDump("null-marker");
                    this.setDumpInfoType("null-type");
                    LOGGER.log(Level.FINE, "Read value: null");
                    Object result = BasicType.NULL;
                    return result;
                }
                case 2: {
                    this.renameLastDump("false-marker");
                    this.setDumpInfoType("false-type");
                    LOGGER.log(Level.FINE, "Read value: false");
                    Object result = Boolean.FALSE;
                    return result;
                }
                case 3: {
                    this.renameLastDump("true-marker");
                    this.setDumpInfoType("true-type");
                    LOGGER.log(Level.FINE, "Read value: true");
                    Object result = Boolean.TRUE;
                    return result;
                }
                case 4: {
                    this.renameLastDump("integer-marker");
                    this.setDumpInfoType("integer-type");
                    LOGGER.log(Level.FINE, "Read value: integer");
                    long ival = this.readS29("intValue");
                    LOGGER.log(Level.FINER, "Integer value: {0}", ival);
                    Object result = ival;
                    return result;
                }
                case 5: {
                    this.renameLastDump("double-marker");
                    this.setDumpInfoType("double-type");
                    LOGGER.log(Level.FINE, "Read value: double");
                    double dval = this.readDouble("doubleValue");
                    LOGGER.log(Level.FINER, "Double value: {0}", "" + dval);
                    Object result = dval;
                    return result;
                }
                case 6: {
                    this.renameLastDump("string-marker");
                    this.setDumpInfoType("string-type");
                    LOGGER.log(Level.FINE, "Read value: string");
                    String sval = this.readUtf8Vr("stringValue", stringTable);
                    LOGGER.log(Level.FINER, "String value: {0}", sval);
                    Object result = sval;
                    return result;
                }
                case 7: {
                    Object result;
                    this.renameLastDump("xml-doc-marker");
                    this.setDumpInfoType("xml-doc-type");
                    LOGGER.log(Level.FINE, "Read value: xml_doc");
                    long xmlDocU29 = this.readU29("U29");
                    int xmlDocNoRefFlag = (int)(xmlDocU29 & 1L);
                    if (xmlDocNoRefFlag == 1) {
                        this.renameU29("U29X-value", NO_REFERENCE_BIT_TEXT, "byte length");
                        long byteLength = xmlDocU29 >> 1;
                        String xval = this.readUtf8Char("characters", byteLength);
                        LOGGER.log(Level.FINER, "XmlDoc value: {0}", xval);
                        XmlDocType retXmlDoc = new XmlDocType(xval);
                        objectTable.add(retXmlDoc);
                        result = retXmlDoc;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexXmlDoc = (int)(xmlDocU29 >> 1);
                        LOGGER.log(Level.FINER, "XmlDoc value: reference({0})", refIndexXmlDoc);
                        result = objectTable.get(refIndexXmlDoc);
                        return result;
                    }
                }
                case 8: {
                    Object result;
                    this.renameLastDump("date-marker");
                    this.setDumpInfoType("date-type");
                    LOGGER.log(Level.FINE, "Read value: date");
                    long dateU29 = this.readU29("U29");
                    int dateNoRefFlag = (int)(dateU29 & 1L);
                    if (dateNoRefFlag == 1) {
                        this.renameU29("U29D-value", NO_REFERENCE_BIT_TEXT, "unused");
                        double dtval = this.readDouble("date-time");
                        DateType retDate = new DateType(dtval);
                        LOGGER.log(Level.FINER, "Date value: {0}", retDate);
                        objectTable.add(retDate);
                        result = retDate;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexDate = (int)(dateU29 >> 1);
                        LOGGER.log(Level.FINER, "Date value: reference({0})", refIndexDate);
                        result = objectTable.get(refIndexDate);
                        return result;
                    }
                }
                case 9: {
                    Object result;
                    this.renameLastDump("array-marker");
                    this.setDumpInfoType("array-type");
                    LOGGER.log(Level.FINE, "Read value: array");
                    long arrayU29 = this.readU29("U29");
                    int arrayNoRefFlag = (int)(arrayU29 & 1L);
                    if (arrayNoRefFlag == 1) {
                        this.renameU29("U29A-value", NO_REFERENCE_BIT_TEXT, "dense count");
                        int denseCount = (int)(arrayU29 >> 1);
                        LOGGER.log(Level.FINEST, "Array value: denseCount={0}", new Object[]{denseCount});
                        ListMap<String, Object> assocPart = new ListMap<String, Object>();
                        ArrayList<Object> densePart = new ArrayList<Object>();
                        ArrayType retArray = new ArrayType();
                        objectTable.add(retArray);
                        this.newDumpLevel("associativeValues", "assoc-value");
                        while (true) {
                            String key;
                            if ((key = this.readUtf8Vr("key", stringTable)).isEmpty()) break;
                            try {
                                Object val = this.readValue("value", serializers, objectTable, traitsTable, stringTable);
                                assocPart.put(key, val);
                            }
                            catch (NoSerializerExistsException nse) {
                                assocPart.put(key, nse.getIncompleteData());
                                retArray.setAssociativeValues(assocPart);
                                throw new NoSerializerExistsException(nse.getClassName(), retArray, nse);
                            }
                        }
                        this.renameLastDump("UTF-8-empty");
                        retArray.setAssociativeValues(assocPart);
                        this.endDumpLevel();
                        LOGGER.log(Level.FINEST, "Array value: assocSize={0}", new Object[]{assocPart.size()});
                        this.newDumpLevel("denseValues", "value-type[]");
                        for (int i = 0; i < denseCount; ++i) {
                            try {
                                densePart.add(this.readValue("denseValue", serializers, objectTable, traitsTable, stringTable));
                                continue;
                            }
                            catch (NoSerializerExistsException nse) {
                                densePart.add(nse.getIncompleteData());
                                for (int j = i + 1; j < denseCount; ++j) {
                                    densePart.add(BasicType.UNKNOWN);
                                }
                                retArray.setDenseValues(densePart);
                                throw new NoSerializerExistsException(nse.getClassName(), retArray, nse);
                            }
                        }
                        retArray.setDenseValues(densePart);
                        this.endDumpLevel();
                        LOGGER.log(Level.FINER, "Array value: dense_size={0},assocSize={1}", new Object[]{densePart.size(), assocPart.size()});
                        result = retArray;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexArray = (int)(arrayU29 >> 1);
                        LOGGER.log(Level.FINER, "Array value: reference({0})", refIndexArray);
                        result = objectTable.get(refIndexArray);
                        return result;
                    }
                }
                case 10: {
                    Object result;
                    this.renameLastDump("object-marker");
                    this.setDumpInfoType("object-type");
                    LOGGER.log(Level.FINE, "Read value: object");
                    long objectU29 = this.readU29("U29");
                    int objectNoRefFlag = (int)(objectU29 & 1L);
                    if (objectNoRefFlag == 1) {
                        Traits traits;
                        int objectTraitsNoRefFlag = (int)(objectU29 >> 1 & 1L);
                        if (objectTraitsNoRefFlag == 1) {
                            int objectTraitsExtFlag = (int)(objectU29 >> 2 & 1L);
                            if (objectTraitsExtFlag == 1) {
                                this.renameU29("U29O-traits-ext", NO_REFERENCE_BIT_TEXT, "not trait reference", "externalized traits", "unused");
                                String className = this.readUtf8Vr("className", stringTable);
                                if (!serializers.containsKey(className)) {
                                    throw new NoSerializerExistsException(className, new ObjectType(new Traits(className, false, new ArrayList()), (byte[])null, new HashMap<String, Object>()), null);
                                }
                                this.newDumpLevel("serializedData", "U8[]");
                                MonitoredInputStream mis = new MonitoredInputStream(this.is);
                                Map<String, Object> serMembers = serializers.get(className).readObject(className, mis);
                                byte[] serData = mis.getReadData();
                                this.endDumpLevel();
                                Traits unserTraits = new Traits(className, false, new ArrayList());
                                ObjectType retObjectType = new ObjectType(unserTraits, serData, serMembers);
                                LOGGER.log(Level.FINER, "Object/Traits value: customSerialized");
                                objectTable.add(retObjectType);
                                result = retObjectType;
                                return result;
                            }
                            this.renameU29("U29O-traits", NO_REFERENCE_BIT_TEXT, "not trait reference", "externalized traits", "dynamic", "sealed count");
                            int dynamicFlag = (int)(objectU29 >> 3 & 1L);
                            int numSealed = (int)(objectU29 >> 4);
                            LOGGER.log(Level.FINEST, "object dynamicFlag:{0}", dynamicFlag);
                            LOGGER.log(Level.FINEST, "object numSealed:{0}", numSealed);
                            String className = this.readUtf8Vr("className", stringTable);
                            LOGGER.log(Level.FINEST, "object className:{0}", className);
                            ArrayList<String> sealedMemberNames = new ArrayList<String>();
                            if (numSealed > 0) {
                                this.newDumpLevel("sealedMemberNames", "UTF-8-vr[]");
                                for (int i = 0; i < numSealed; ++i) {
                                    sealedMemberNames.add(this.readUtf8Vr("sealedMemberName", stringTable));
                                }
                                this.endDumpLevel();
                            }
                            traits = new Traits(className, dynamicFlag == 1, sealedMemberNames);
                            traitsTable.add(traits);
                        } else {
                            this.renameU29Traits_ref();
                            int refIndexTraits = (int)(objectU29 >> 2);
                            traits = traitsTable.get(refIndexTraits);
                            LOGGER.log(Level.FINER, "Traits value: reference({0}) - traitsize={1}", new Object[]{refIndexTraits, traits.getSealedMemberNames().size()});
                        }
                        ListMap<String, Object> sealedMembers = new ListMap<String, Object>();
                        ListMap<String, Object> dynamicMembers = new ListMap<String, Object>();
                        ObjectType retObjectType = new ObjectType(traits);
                        objectTable.add(retObjectType);
                        ArrayList<Object> sealedMemberValues = new ArrayList<Object>();
                        NoSerializerExistsException error = null;
                        if (!traits.getSealedMemberNames().isEmpty()) {
                            this.newDumpLevel("sealedMemberValues", "value-type[]");
                            for (int i = 0; i < traits.getSealedMemberNames().size(); ++i) {
                                try {
                                    sealedMemberValues.add(this.readValue("sealedMemberValue", serializers, objectTable, traitsTable, stringTable));
                                    continue;
                                }
                                catch (NoSerializerExistsException nse) {
                                    sealedMemberValues.add(nse.getIncompleteData());
                                    for (int j = i + 1; j < traits.getSealedMemberNames().size(); ++j) {
                                        sealedMemberValues.add(BasicType.UNKNOWN);
                                    }
                                    error = nse;
                                    break;
                                }
                            }
                            this.endDumpLevel();
                        }
                        ArrayList<String> memberNames = new ArrayList<String>();
                        memberNames.addAll(traits.getSealedMemberNames());
                        for (int i = 0; i < memberNames.size(); ++i) {
                            sealedMembers.put((String)memberNames.get(i), sealedMemberValues.get(i));
                        }
                        retObjectType.setSealedMembers(sealedMembers);
                        if (traits.isDynamic()) {
                            String dynamicMemberName;
                            this.newDumpLevel("dynamicMembers", "dynamic-member[]");
                            while (!(dynamicMemberName = this.readUtf8Vr("name", stringTable)).isEmpty()) {
                                DumpInfo memberDumpInfo;
                                DumpInfo nameDumpInfo;
                                DumpInfo valueDumpInfo;
                                try {
                                    Object dynamicMemberValue = this.readValue("value", serializers, objectTable, traitsTable, stringTable);
                                    dynamicMembers.put(dynamicMemberName, dynamicMemberValue);
                                    if (this.dumpInfo == null) continue;
                                    valueDumpInfo = this.dumpInfo.getChildInfos().remove(this.dumpInfo.getChildInfos().size() - 1);
                                    nameDumpInfo = this.dumpInfo.getChildInfos().remove(this.dumpInfo.getChildInfos().size() - 1);
                                    memberDumpInfo = new DumpInfo("member", "dynamic-member", "", nameDumpInfo.startByte, nameDumpInfo.lengthBytes + valueDumpInfo.lengthBytes);
                                    memberDumpInfo.getChildInfos().add(nameDumpInfo);
                                }
                                catch (NoSerializerExistsException nse) {
                                    try {
                                        dynamicMembers.put(dynamicMemberName, nse.getIncompleteData());
                                        retObjectType.setDynamicMembers(dynamicMembers);
                                        throw new NoSerializerExistsException(nse.getClassName(), retObjectType, nse);
                                    }
                                    catch (Throwable throwable) {
                                        if (this.dumpInfo == null) throw throwable;
                                        DumpInfo valueDumpInfo2 = this.dumpInfo.getChildInfos().remove(this.dumpInfo.getChildInfos().size() - 1);
                                        DumpInfo nameDumpInfo2 = this.dumpInfo.getChildInfos().remove(this.dumpInfo.getChildInfos().size() - 1);
                                        DumpInfo memberDumpInfo2 = new DumpInfo("member", "dynamic-member", "", nameDumpInfo2.startByte, nameDumpInfo2.lengthBytes + valueDumpInfo2.lengthBytes);
                                        memberDumpInfo2.getChildInfos().add(nameDumpInfo2);
                                        memberDumpInfo2.getChildInfos().add(valueDumpInfo2);
                                        memberDumpInfo2.parent = this.dumpInfo;
                                        nameDumpInfo2.parent = memberDumpInfo2;
                                        valueDumpInfo2.parent = memberDumpInfo2;
                                        memberDumpInfo2.previewValue = "" + nameDumpInfo2.previewValue + (valueDumpInfo2.previewValue != null ? " : " + valueDumpInfo2.previewValue : "");
                                        this.dumpInfo.getChildInfos().add(memberDumpInfo2);
                                        throw throwable;
                                    }
                                }
                                memberDumpInfo.getChildInfos().add(valueDumpInfo);
                                memberDumpInfo.parent = this.dumpInfo;
                                nameDumpInfo.parent = memberDumpInfo;
                                valueDumpInfo.parent = memberDumpInfo;
                                memberDumpInfo.previewValue = "" + nameDumpInfo.previewValue + (valueDumpInfo.previewValue != null ? " : " + valueDumpInfo.previewValue : "");
                                this.dumpInfo.getChildInfos().add(memberDumpInfo);
                            }
                            retObjectType.setDynamicMembers(dynamicMembers);
                            this.renameLastDump("UTF-8-empty");
                            this.endDumpLevel();
                        }
                        LOGGER.log(Level.FINER, "Object value: dynamic={0},className={1},sealedSize={2},dynamicSize={3}", new Object[]{traits.isDynamic(), traits.getClassName(), sealedMembers.size(), dynamicMembers.size()});
                        result = retObjectType;
                        return result;
                    }
                    this.renameU29O_ref();
                    int refIndexObject = (int)(objectU29 >> 1);
                    LOGGER.log(Level.FINER, "Object value: reference({0})", refIndexObject);
                    result = objectTable.get(refIndexObject);
                    return result;
                }
                case 11: {
                    Object result;
                    this.renameLastDump("xml-marker");
                    this.setDumpInfoType("xml-type");
                    LOGGER.log(Level.FINE, "Read value: xml");
                    long xmlU29 = this.readU29("U29");
                    int xmlNoRefFlag = (int)(xmlU29 & 1L);
                    if (xmlNoRefFlag == 1) {
                        this.renameU29("U29X-value", NO_REFERENCE_BIT_TEXT, "byte length");
                        long byteLength = xmlU29 >> 1;
                        String xString = this.readUtf8Char("characters", byteLength);
                        XmlType retXmlType = new XmlType(xString);
                        LOGGER.log(Level.FINER, "Xml value: {0}", xString);
                        objectTable.add(retXmlType);
                        result = retXmlType;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexXml = (int)(xmlU29 >> 1);
                        LOGGER.log(Level.FINER, "XML value: reference({0})", refIndexXml);
                        result = objectTable.get(refIndexXml);
                        return result;
                    }
                }
                case 12: {
                    Object result;
                    this.renameLastDump("byte-array-marker");
                    this.setDumpInfoType("bytearray-type");
                    LOGGER.log(Level.FINE, "Read value: bytearray");
                    long byteArrayU29 = this.readU29("U29");
                    int byteArrayNoRefFlag = (int)(byteArrayU29 & 1L);
                    if (byteArrayNoRefFlag == 1) {
                        this.renameU29("U29B-value", NO_REFERENCE_BIT_TEXT, "byte array length");
                        int byteArrayLength = (int)(byteArrayU29 >> 1);
                        this.newDumpLevel("bytes", "U8[]");
                        byte[] byteArrayBuf = new byte[byteArrayLength];
                        if (this.is.read(byteArrayBuf) != byteArrayLength) {
                            throw new EndOfStreamException();
                        }
                        this.endDumpLevel();
                        LOGGER.log(Level.FINER, "ByteArray value: bytes[{0}]", byteArrayLength);
                        ByteArrayType retByteArrayType = new ByteArrayType(byteArrayBuf);
                        objectTable.add(retByteArrayType);
                        result = retByteArrayType;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexByteArray = (int)(byteArrayU29 >> 1);
                        LOGGER.log(Level.FINER, "ByteArray value: reference({0})", refIndexByteArray);
                        result = objectTable.get(refIndexByteArray);
                        return result;
                    }
                }
                case 13: {
                    Object result;
                    this.renameLastDump("vector-int-marker");
                    this.setDumpInfoType("vector-int-type");
                    LOGGER.log(Level.FINE, "Read value: vector_int");
                    long vectorIntU29 = this.readU29("U29");
                    int vectorIntNoRefFlag = (int)(vectorIntU29 & 1L);
                    if (vectorIntNoRefFlag == 1) {
                        this.renameU29("U29V-value", NO_REFERENCE_BIT_TEXT, "item count");
                        int vectorIntCountItems = (int)(vectorIntU29 >> 1);
                        int fixed = this.readU8("fixed");
                        ArrayList<Long> vals = new ArrayList<Long>();
                        this.newDumpLevel("items", "S32[]");
                        for (int i = 0; i < vectorIntCountItems; ++i) {
                            vals.add(this.readS32("intValue"));
                        }
                        this.endDumpLevel();
                        VectorIntType retVectorInt = new VectorIntType(fixed == 1, (List<Long>)vals);
                        LOGGER.log(Level.FINER, "Vector<int> value: fixed={0}, size={1}]", new Object[]{fixed, vectorIntCountItems});
                        objectTable.add(retVectorInt);
                        result = retVectorInt;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexVectorInt = (int)(vectorIntU29 >> 1);
                        LOGGER.log(Level.FINER, "Vector<int> value: reference({0})", refIndexVectorInt);
                        result = objectTable.get(refIndexVectorInt);
                        return result;
                    }
                }
                case 14: {
                    Object result;
                    this.renameLastDump("vector-uint-marker");
                    this.setDumpInfoType("vector-uint-type");
                    LOGGER.log(Level.FINE, "Read value: vector_uint");
                    long vectorUIntU29 = this.readU29("U29");
                    int vectorUIntNoRefFlag = (int)(vectorUIntU29 & 1L);
                    if (vectorUIntNoRefFlag == 1) {
                        this.renameU29("U29V-value", NO_REFERENCE_BIT_TEXT, "item count");
                        int vectorUIntCountItems = (int)(vectorUIntU29 >> 1);
                        int fixed = this.readU8("fixed");
                        ArrayList<Long> vals = new ArrayList<Long>();
                        this.newDumpLevel("items", "U32[]");
                        for (int i = 0; i < vectorUIntCountItems; ++i) {
                            vals.add(this.readU32("uintValue"));
                        }
                        this.endDumpLevel();
                        VectorUIntType retVectorUInt = new VectorUIntType(fixed == 1, (List<Long>)vals);
                        LOGGER.log(Level.FINER, "Vector<uint> value: fixed={0}, size={1}]", new Object[]{fixed, vectorUIntCountItems});
                        objectTable.add(retVectorUInt);
                        result = retVectorUInt;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexVectorUInt = (int)(vectorUIntU29 >> 1);
                        LOGGER.log(Level.FINER, "Vector<uint> value: reference({0})", refIndexVectorUInt);
                        result = objectTable.get(refIndexVectorUInt);
                        return result;
                    }
                }
                case 15: {
                    Object result;
                    this.renameLastDump("vector-double-marker");
                    this.setDumpInfoType("vector-double-type");
                    LOGGER.log(Level.FINE, "Read value: vector_double");
                    long vectorDoubleU29 = this.readU29("U29");
                    int vectorDoubleNoRefFlag = (int)(vectorDoubleU29 & 1L);
                    if (vectorDoubleNoRefFlag == 1) {
                        this.renameU29("U29V-value", NO_REFERENCE_BIT_TEXT, "item count");
                        int vectorDoubleCountItems = (int)(vectorDoubleU29 >> 1);
                        int fixed = this.readU8("fixed");
                        ArrayList<Double> vals = new ArrayList<Double>();
                        this.newDumpLevel("items", "DOUBLE[]");
                        for (int i = 0; i < vectorDoubleCountItems; ++i) {
                            vals.add(this.readDouble("doubleValue"));
                        }
                        this.endDumpLevel();
                        VectorDoubleType retVectorDouble = new VectorDoubleType(fixed == 1, (List<Double>)vals);
                        LOGGER.log(Level.FINER, "Vector<double> value: fixed={0}, size={1}]", new Object[]{fixed, vectorDoubleCountItems});
                        objectTable.add(retVectorDouble);
                        result = retVectorDouble;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexVectorDouble = (int)(vectorDoubleU29 >> 1);
                        LOGGER.log(Level.FINER, "Vector<double> value: reference({0})", refIndexVectorDouble);
                        result = objectTable.get(refIndexVectorDouble);
                        return result;
                    }
                }
                case 16: {
                    Object result;
                    this.renameLastDump("vector-object-marker");
                    this.setDumpInfoType("vector-object-type");
                    LOGGER.log(Level.FINE, "Read value: vector_object");
                    long vectorObjectU29 = this.readU29("U29");
                    int vectorObjectNoRefFlag = (int)(vectorObjectU29 & 1L);
                    if (vectorObjectNoRefFlag == 1) {
                        this.renameU29("U29V-value", NO_REFERENCE_BIT_TEXT, "item count");
                        int vectorObjectCountItems = (int)(vectorObjectU29 >> 1);
                        int fixed = this.readU8("fixed");
                        String objectTypeName = this.readUtf8Vr("object-type-name", stringTable);
                        ArrayList<Object> vals = new ArrayList<Object>();
                        NoSerializerExistsException error = null;
                        this.newDumpLevel("items", "value_type[]");
                        for (int i = 0; i < vectorObjectCountItems; ++i) {
                            try {
                                vals.add(this.readValue("value", serializers, objectTable, traitsTable, stringTable));
                                continue;
                            }
                            catch (NoSerializerExistsException nse) {
                                vals.add(nse.getIncompleteData());
                                for (int j = i + 1; j < vectorObjectCountItems; ++j) {
                                    vals.add(BasicType.UNKNOWN);
                                }
                                error = nse;
                                break;
                            }
                        }
                        this.endDumpLevel();
                        VectorObjectType retVectorObject = new VectorObjectType(fixed == 1, objectTypeName, vals);
                        LOGGER.log(Level.FINER, "Vector<Object> value: fixed={0}, size={1}, typeName:{2}]", new Object[]{fixed, vectorObjectCountItems, objectTypeName});
                        objectTable.add(retVectorObject);
                        if (error != null) {
                            throw new NoSerializerExistsException(error.getClassName(), retVectorObject, error);
                        }
                        result = retVectorObject;
                        return result;
                    } else {
                        this.renameU29O_ref();
                        int refIndexVectorObject = (int)(vectorObjectU29 >> 1);
                        LOGGER.log(Level.FINER, "Vector<Object> value: reference({0})", refIndexVectorObject);
                        result = objectTable.get(refIndexVectorObject);
                        return result;
                    }
                }
                case 17: {
                    Object result;
                    this.renameLastDump("dictionary-marker");
                    this.setDumpInfoType("dictionary-type");
                    long dictionaryObjectU29 = this.readU29("U29");
                    int dictionaryNoRefFlag = (int)(dictionaryObjectU29 & 1L);
                    if (dictionaryNoRefFlag == 1) {
                        this.renameU29("U29Dict-value", NO_REFERENCE_BIT_TEXT, "entries count");
                        int numEntries = (int)(dictionaryObjectU29 >> 1);
                        int weakKeys = this.readU8("weak keys");
                        ListMap data = new ListMap(true);
                        DictionaryType retDictionary = new DictionaryType(weakKeys == 1);
                        objectTable.add(retDictionary);
                        NoSerializerExistsException error = null;
                        this.newDumpLevel("entries", "");
                        for (int i = 0; i < numEntries; ++i) {
                            Object val;
                            Object key;
                            try {
                                key = this.readValue("entry-key", serializers, objectTable, traitsTable, stringTable);
                                try {
                                    val = this.readValue("entry-value", serializers, objectTable, traitsTable, stringTable);
                                }
                                catch (NoSerializerExistsException nse) {
                                    error = nse;
                                    val = BasicType.UNKNOWN;
                                }
                            }
                            catch (NoSerializerExistsException nse) {
                                error = nse;
                                key = BasicType.UNKNOWN;
                                val = BasicType.UNKNOWN;
                            }
                            retDictionary.put(key, val);
                            if (error == null) continue;
                            for (int j = i + 1; j < numEntries; ++j) {
                                retDictionary.put(BasicType.UNKNOWN, BasicType.UNKNOWN);
                            }
                            break;
                        }
                        this.endDumpLevel();
                        if (error != null) {
                            throw new NoSerializerExistsException(error.getClassName(), retDictionary, error);
                        }
                        result = retDictionary;
                        return result;
                    }
                    this.renameU29O_ref();
                    int refIndexDictionary = (int)(dictionaryObjectU29 >> 1);
                    LOGGER.log(Level.FINER, "Dictionary value: reference({0})", refIndexDictionary);
                    result = objectTable.get(refIndexDictionary);
                    return result;
                }
                default: {
                    throw new UnsupportedValueTypeException(marker);
                }
            }
        }
        finally {
            this.endDumpLevel();
        }
    }

    private static String valToPreviewString(Object v) {
        if (v instanceof ObjectType) {
            return "{...}";
        }
        if (v instanceof ArrayType) {
            return "[...]";
        }
        if (v instanceof DictionaryType) {
            return "";
        }
        if (v instanceof BasicType) {
            return "";
        }
        if (v instanceof DateType) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
            return sdf.format(((DateType)v).toDate());
        }
        if (v instanceof String) {
            return "\"" + Helper.escapeActionScriptString((String)v) + "\"";
        }
        return EcmaScript.toString(v);
    }

    private class MonitoredInputStream
    extends InputStream {
        private final InputStream is;
        private ByteArrayOutputStream baos;

        public MonitoredInputStream(InputStream is) {
            this.is = is;
            this.baos = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int ret = this.is.read();
            if (ret > -1) {
                this.baos.write(ret);
            }
            return ret;
        }

        public byte[] getReadData() {
            return this.baos.toByteArray();
        }
    }
}

