/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Set;

public class StoreRegisterActionItem
extends ActionItem
implements SetTypeActionItem {
    public RegisterNumber register;
    public boolean define = false;
    public boolean temporary = false;
    private int tempRegister = -1;

    @Override
    public GraphPart getFirstPart() {
        return this.value.getFirstPart();
    }

    @Override
    public void setValue(GraphTargetItem value) {
        this.value = value;
    }

    @Override
    public int getTempRegister() {
        return this.tempRegister;
    }

    @Override
    public void setTempRegister(int tempRegister) {
        this.tempRegister = tempRegister;
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    public StoreRegisterActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, RegisterNumber register, GraphTargetItem value, boolean define) {
        super(instruction, lineStartIns, 14, value);
        this.register = register;
        this.define = define;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.temporary) {
            this.value.toString(writer, localData);
        } else {
            HighlightData srcData = this.getSrcData();
            srcData.localName = this.register.translate();
            srcData.regIndex = this.register.number;
            if (this.define) {
                srcData.declaration = true;
                srcData.declaredType = DottedChain.ALL;
                writer.append("var ");
            }
            writer.append(this.register.translate()).append(" = ");
            this.value.toString(writer, localData);
        }
        return writer;
    }

    @Override
    public GraphTargetItem getObject() {
        return new DirectValueActionItem(this.getSrc(), this.getLineStartItem(), -1, this.register, null);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return StoreRegisterActionItem.toSourceMerge(localData, generator, this.value, new ActionStoreRegister(this.register.number));
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public Object getResult() {
        return this.value.getResult();
    }
}

