/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionMBStringExtract;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class MBStringExtractActionItem
extends ActionItem {
    public GraphTargetItem index;
    public GraphTargetItem count;

    @Override
    public List<GraphTargetItem> getAllSubItems() {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ret.add(this.value);
        ret.add(this.index);
        ret.add(this.count);
        return ret;
    }

    public MBStringExtractActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, GraphTargetItem index, GraphTargetItem count) {
        super(instruction, lineStartIns, 0, value);
        this.index = index;
        this.count = count;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("mbsubstring");
        writer.spaceBeforeCallParenthesies(3);
        writer.append("(");
        this.value.toString(writer, localData);
        writer.append(",");
        this.index.toString(writer, localData);
        writer.append(",");
        this.count.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        ret.addAll(this.index.getNeededSources());
        ret.addAll(this.count.getNeededSources());
        return ret;
    }

    @Override
    public Object getResult() {
        return MBStringExtractActionItem.getResult(this.count.getResult(), this.index.getResult(), this.value.getResult());
    }

    public static String getResult(Object count, Object index, Object value) {
        String str = EcmaScript.toString(value);
        int idx = EcmaScript.toInt32(index);
        int cnt = EcmaScript.toInt32(count);
        if (--idx < 0) {
            idx = 0;
        } else if (idx > str.length()) {
            return "";
        }
        if (cnt < 0) {
            cnt = str.length();
        }
        int endIdx = Math.min(str.length(), idx + cnt);
        return str.substring(idx, endIdx);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return MBStringExtractActionItem.toSourceMerge(localData, generator, this.value, this.index, this.count, new ActionMBStringExtract());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

