/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf3.ActionGotoFrame;
import com.jpexs.decompiler.flash.action.swf3.ActionPlay;
import com.jpexs.decompiler.flash.action.swf4.ActionGotoFrame2;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class GotoFrame2ActionItem
extends ActionItem {
    public GraphTargetItem frame;
    public boolean sceneBiasFlag;
    public boolean playFlag;
    public int sceneBias;

    @Override
    public List<GraphTargetItem> getAllSubItems() {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ret.add(this.frame);
        return ret;
    }

    public GotoFrame2ActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem frame, boolean sceneBiasFlag, boolean playFlag, int sceneBias) {
        super(instruction, lineStartIns, 0);
        this.frame = frame;
        this.sceneBiasFlag = sceneBiasFlag;
        this.playFlag = playFlag;
        this.sceneBias = sceneBias;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String prefix = "gotoAndStop";
        if (this.playFlag) {
            prefix = "gotoAndPlay";
        }
        writer.append(prefix);
        writer.spaceBeforeCallParenthesies(1);
        writer.append("(");
        this.frame.toString(writer, localData);
        writer.append(this.sceneBiasFlag ? "," + this.sceneBias : "");
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.frame.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (!this.sceneBiasFlag && this.frame instanceof DirectValueActionItem && ((DirectValueActionItem)this.frame).value instanceof Long) {
            return GotoFrame2ActionItem.toSourceMerge(localData, generator, new ActionGotoFrame((int)((Long)((DirectValueActionItem)this.frame).value).longValue() - 1), this.playFlag ? new ActionPlay() : null);
        }
        return GotoFrame2ActionItem.toSourceMerge(localData, generator, this.frame, new ActionGotoFrame2(this.playFlag, this.sceneBiasFlag, this.sceneBias));
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

