/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.fastactionlist;

import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.fastactionlist.ActionItem;
import com.jpexs.decompiler.flash.action.fastactionlist.FastActionListIterator;
import com.jpexs.decompiler.flash.action.special.ActionStore;
import com.jpexs.decompiler.flash.action.special.ActionUnknown;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FastActionList
implements Collection<ActionItem> {
    private int size;
    private ActionItem firstItem;
    private final Map<Action, ActionItem> actionItemMap;
    private final Set<ActionItem> actionItemSet;

    public FastActionList(ActionList actions) {
        this.actionItemMap = new HashMap<Action, ActionItem>(actions.size());
        this.actionItemSet = new HashSet<ActionItem>(actions.size());
        for (Action action : actions) {
            this.insertItemAfter(null, action);
        }
        this.size = actions.size();
        this.getContainerLastActions(actions, this.actionItemMap);
        this.getJumps(actions, this.actionItemMap);
    }

    public final ActionItem insertItemBefore(ActionItem item, Action action) {
        ActionItem newItem = new ActionItem(action);
        return this.insertItemBefore(item, newItem);
    }

    public final ActionItem insertItemAfter(ActionItem item, Action action) {
        ActionItem newItem = new ActionItem(action);
        return this.insertItemAfter(item, newItem);
    }

    public final ActionItem insertItemBefore(ActionItem item, ActionItem newItem) {
        this.insertItemAfter(item.prev, newItem);
        if (item == this.firstItem) {
            this.firstItem = newItem;
        }
        return newItem;
    }

    public final ActionItem insertItemAfter(ActionItem item, ActionItem newItem) {
        if (item == null && this.firstItem == null) {
            this.firstItem = newItem;
            newItem.next = newItem;
            newItem.prev = newItem;
        } else {
            if (item == null) {
                item = this.firstItem.prev;
            }
            ActionItem oldNext = item.next;
            newItem.prev = item;
            newItem.next = oldNext;
            item.next = newItem;
            oldNext.prev = newItem;
        }
        ++this.size;
        this.actionItemMap.put(newItem.action, newItem);
        this.actionItemSet.add(newItem);
        return newItem;
    }

    public ActionItem removeItem(ActionItem item) {
        ActionItem next = null;
        if (item == this.firstItem) {
            if (item.next == item) {
                this.firstItem = null;
            } else {
                this.firstItem = next = item.next;
                next.prev = item.prev;
                item.prev.next = next;
            }
        } else {
            item.prev.next = next = item.next;
            next.prev = item.prev;
        }
        --this.size;
        this.actionItemMap.remove(item.action);
        this.actionItemSet.remove(item);
        item.removeJumpTarget();
        item.removeContainerLastActions();
        if (item.jumpsHere != null) {
            for (ActionItem item1 : new ArrayList<ActionItem>(item.jumpsHere)) {
                item1.setJumpTarget(item.next);
            }
        }
        if (item.lastActionOf != null) {
            for (ActionItem item1 : new ArrayList<ActionItem>(item.lastActionOf)) {
                item1.replaceContainerLastAction(item, item.prev);
            }
        }
        return next;
    }

    public void removeItem(int index, int count) {
        FastActionListIterator iterator = new FastActionListIterator(this, index);
        for (int i = 0; i < count; ++i) {
            iterator.next();
            iterator.remove();
        }
    }

    public ActionItem get(int index) {
        FastActionListIterator iterator = new FastActionListIterator(this, index);
        return iterator.next();
    }

    public void replaceJumpTargets(ActionItem target, ActionItem newTarget) {
        if (target.jumpsHere != null) {
            for (ActionItem item : new ArrayList<ActionItem>(target.jumpsHere)) {
                item.setJumpTarget(newTarget);
            }
        }
    }

    private void getContainerLastActions(ActionList actions, Map<Action, ActionItem> actionItemMap) {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            Action action;
            if (!((action = item.action) instanceof GraphSourceItemContainer)) continue;
            item.setContainerLastActions(this.getContainerLastActions(actions, action, actionItemMap));
        } while ((item = item.next) != this.firstItem);
    }

    private List<ActionItem> getContainerLastActions(ActionList actions, Action action, Map<Action, ActionItem> actionItemMap) {
        GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)action);
        List<Long> sizes = container.getContainerSizes();
        long endAddress = action.getAddress() + container.getHeaderSize();
        ArrayList<ActionItem> lasts = new ArrayList<ActionItem>(sizes.size());
        for (long size : sizes) {
            long lastActionAddress = this.getNearAddress(actions, (endAddress += size) - 1L, false);
            Action lastAction = null;
            if (lastActionAddress != -1L) {
                lastAction = actions.getByAddress(lastActionAddress);
            }
            if (lastAction != null) {
                lasts.add(actionItemMap.get(lastAction));
                continue;
            }
            lasts.add(null);
        }
        return lasts;
    }

    private long getNearAddress(ActionList actions, long address, boolean next) {
        int min = 0;
        int max = actions.size() - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            long midValue = ((Action)actions.get(mid)).getAddress();
            if (midValue == address) {
                return address;
            }
            if (midValue < address) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return next ? (min < actions.size() ? ((Action)actions.get(min)).getAddress() : -1L) : (max >= 0 ? ((Action)actions.get(max)).getAddress() : -1L);
    }

    private void getJumps(ActionList actions, Map<Action, ActionItem> actionItemMap) {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            Action action = item.action;
            long target = -1L;
            if (action instanceof ActionIf) {
                target = ((ActionIf)action).getTargetAddress();
            } else if (action instanceof ActionJump) {
                target = ((ActionJump)action).getTargetAddress();
            } else if (action instanceof ActionStore) {
                long address;
                ActionStore aStore = (ActionStore)((Object)action);
                int storeSize = aStore.getStoreSize();
                Action targetAction = action;
                for (int i = 0; i <= storeSize && (targetAction = actions.getByAddress(address = targetAction.getAddress() + (long)targetAction.getTotalActionLength())) != null; ++i) {
                }
                item.setJumpTarget(actionItemMap.get(targetAction));
            }
            if (target < 0L) continue;
            Action targetAction = actions.getByAddress(target);
            item.setJumpTarget(actionItemMap.get(targetAction));
        } while ((item = item.next) != this.firstItem);
    }

    private void updateActionAddressesAndLengths() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        long address = item.action.getAddress();
        do {
            Action action = item.action;
            action.setAddress(address);
            action.updateLength();
            address += (long)action.getTotalActionLength();
        } while ((item = item.next) != this.firstItem);
    }

    private void updateJumps() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        long endAddress = item.prev.action.getAddress();
        do {
            long offset;
            Action target;
            Action action;
            if ((action = item.action) instanceof ActionIf) {
                ActionIf aIf = (ActionIf)action;
                target = item.getJumpTargetAction();
                offset = target != null ? target.getAddress() - action.getAddress() - (long)action.getTotalActionLength() : endAddress - action.getAddress() - (long)action.getTotalActionLength();
                aIf.setJumpOffset((int)offset);
                continue;
            }
            if (!(action instanceof ActionJump)) continue;
            ActionJump aJump = (ActionJump)action;
            target = item.getJumpTargetAction();
            offset = target != null ? target.getAddress() - action.getAddress() - (long)action.getTotalActionLength() : endAddress - action.getAddress() - (long)action.getTotalActionLength();
            aJump.setJumpOffset((int)offset);
        } while ((item = item.next) != this.firstItem);
    }

    private void updateActionStores() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            Action action;
            if (!((action = item.action) instanceof ActionStore)) continue;
            ActionStore aStore = (ActionStore)((Object)action);
            Action nextActionAfterStore = item.getJumpTargetAction();
            ActionItem item1 = item;
            ArrayList<Action> store = new ArrayList<Action>();
            while ((item1 = item1.next) != this.firstItem && item1.action != nextActionAfterStore) {
                store.add(item1.action);
            }
            aStore.setStore(store);
        } while ((item = item.next) != this.firstItem);
    }

    private void updateContainerSizes() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            Action action;
            if (!((action = item.action) instanceof GraphSourceItemContainer)) continue;
            GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)action);
            List<ActionItem> lastActions = item.getContainerLastActions();
            long startAddress = action.getAddress() + container.getHeaderSize();
            for (int j = 0; j < lastActions.size(); ++j) {
                Action lastAction = lastActions.get((int)j).action;
                int length = (int)(lastAction.getAddress() + (long)lastAction.getTotalActionLength() - startAddress);
                container.setContainerSize(j, length);
                startAddress += (long)length;
            }
        } while ((item = item.next) != this.firstItem);
    }

    public ActionItem getContainer(ActionItem item) {
        while (!(item.action instanceof GraphSourceItemContainer) && item != this.firstItem) {
            item = item.prev;
        }
        if (item.action instanceof GraphSourceItemContainer) {
            return item;
        }
        return null;
    }

    public void expandPushes() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            Action action;
            if (!((action = item.action) instanceof ActionPush)) continue;
            ActionPush push = (ActionPush)action;
            if (push.values.size() <= 1) continue;
            for (int i = 1; i < push.values.size(); ++i) {
                Object value = push.values.get(i);
                ActionPush newPush = new ActionPush(value);
                newPush.constantPool = push.constantPool;
                this.insertItemAfter(item, newPush);
                item = item.next;
            }
            Object obj = push.values.get(0);
            push.values.clear();
            push.values.add(obj);
        } while ((item = item.next) != this.firstItem);
    }

    public void removeUnknownActions() {
        Action action;
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        while ((item = (action = item.action) instanceof ActionUnknown ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public void removeZeroJumps() {
        Action action;
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        while ((item = (action = item.action) instanceof ActionJump && item.getJumpTarget() == item.next && item.getJumpTarget() != this.firstItem ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public void removeUnreachableActions() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        this.updateReachableFlags(null, null);
        while ((item = item.reachable == 0 ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public void removeIncludedActions() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        while ((item = !item.excluded ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public int getUnreachableActionCount(ActionItem jump, ActionItem jumpTarget) {
        ActionItem item = this.firstItem;
        if (item == null) {
            return 0;
        }
        this.updateReachableFlags(jump, jumpTarget);
        jump.reachable = 0;
        int count = 0;
        do {
            if (item.reachable != 0) continue;
            ++count;
        } while ((item = item.next) != this.firstItem);
        return count;
    }

    private void clearReachableFlags() {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            item.reachable = 0;
        } while ((item = item.next) != this.firstItem);
    }

    public void setExcludedFlags(boolean value) {
        ActionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            item.excluded = value;
        } while ((item = item.next) != this.firstItem);
    }

    private void updateReachableFlags(ActionItem jump, ActionItem jumpTarget) {
        if (this.firstItem == null) {
            return;
        }
        this.clearReachableFlags();
        this.firstItem.reachable = 1;
        ActionItem firstItem2 = this.firstItem;
        boolean modified = true;
        while (modified) {
            ActionItem next;
            modified = false;
            ActionItem item = firstItem2;
            do {
                ActionItem target;
                next = item.next;
                Action action = item.action;
                if (item.reachable != 1) continue;
                item.reachable = 2;
                modified = true;
                if (item == firstItem2) {
                    firstItem2 = next;
                }
                if (item == jump) {
                    if (jumpTarget.reachable != 0) continue;
                    jumpTarget.reachable = 1;
                    continue;
                }
                if (!action.isExit() && !(action instanceof ActionJump) && next.reachable == 0) {
                    next.reachable = 1;
                }
                if (action instanceof GraphSourceItemContainer) {
                    for (ActionItem lastActionItem : item.getContainerLastActions()) {
                        if (lastActionItem == null || lastActionItem.next == null || lastActionItem.next.reachable != 0) continue;
                        lastActionItem.next.reachable = 1;
                    }
                }
                if ((target = item.getJumpTarget()) == null || target.reachable != 0) continue;
                target.reachable = 1;
            } while ((item = next) != this.firstItem);
        }
    }

    public ActionList updateActions() {
        ArrayList<Action> resultList = new ArrayList<Action>(this.size);
        ActionItem item = this.firstItem;
        if (item == null) {
            return new ActionList((Collection<Action>)resultList);
        }
        do {
            resultList.add(item.action);
        } while ((item = item.next) != this.firstItem);
        ActionList result = new ActionList((Collection<Action>)resultList);
        this.updateActionAddressesAndLengths();
        this.updateJumps();
        this.updateActionStores();
        this.updateContainerSizes();
        return result;
    }

    public ActionItem first() {
        return this.firstItem;
    }

    public ActionItem last() {
        return this.firstItem == null ? null : this.firstItem.prev;
    }

    public ActionList toActionList() {
        return this.updateActions();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ActionItem) {
            return this.actionItemSet.contains(o);
        }
        if (o instanceof Action) {
            return this.actionItemMap.containsKey((Action)o);
        }
        return false;
    }

    public FastActionListIterator iterator() {
        return new FastActionListIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        ActionItem item = this.firstItem;
        if (item == null) {
            return result;
        }
        int i = 0;
        do {
            result[i] = item.action;
            item = item.next;
            ++i;
        } while (item != this.firstItem);
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ActionItem item;
        if (a.length != this.size) {
            a = new ActionItem[this.size];
        }
        if ((item = this.firstItem) == null) {
            return a;
        }
        int i = 0;
        do {
            a[i] = item;
            item = item.next;
            ++i;
        } while (item != this.firstItem);
        return null;
    }

    @Override
    public boolean add(ActionItem e) {
        this.insertItemAfter(null, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        ActionItem item = null;
        if (o instanceof ActionItem) {
            item = (ActionItem)o;
        } else if (o instanceof Action) {
            item = this.actionItemMap.get((Action)o);
        }
        if (item == null) {
            return false;
        }
        this.removeItem(item);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object c1 : c) {
            if (this.contains(c1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ActionItem> c) {
        for (ActionItem actionItem : c) {
            this.insertItemAfter(null, actionItem);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object c1 : c) {
            result |= this.remove(c1);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ActionItem item = this.firstItem;
        if (item == null) {
            return false;
        }
        boolean modified = false;
        do {
            if (!c.contains(item)) {
                item = this.removeItem(item);
                modified = true;
                continue;
            }
            item = item.next;
        } while (item != this.firstItem);
        return modified;
    }

    @Override
    public void clear() {
        this.firstItem = null;
        this.size = 0;
    }
}

