/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.PropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.Reference;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NamespaceItem {
    public DottedChain name;
    public int kind;
    private int nsIndex = -1;

    public void forceResolve(AbcIndexing abcIndex) {
        this.nsIndex = abcIndex.getSelectedAbc().constants.getNamespaceId(this.kind, this.name, 0, true);
    }

    public NamespaceItem(DottedChain name, int kind) {
        this.name = name;
        this.kind = kind;
    }

    public NamespaceItem(String name, int kind) {
        this.name = DottedChain.parseWithSuffix(name);
        this.kind = kind;
    }

    public String toString() {
        return Namespace.kindToStr(this.kind) + " " + this.name.toRawString();
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceItem other = (NamespaceItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return this.kind == other.kind;
    }

    public void resolveCustomNs(AbcIndexing abcIndex, List<DottedChain> importedClasses, DottedChain pkg, List<NamespaceItem> openedNamespaces, SourceGeneratorLocalData localData) throws CompilationException {
        if (this.nsIndex > -1) {
            return;
        }
        if (this.kind == 8) {
            String custom = this.name.toRawString();
            PropertyAVM2Item prop = new PropertyAVM2Item(null, custom, abcIndex, openedNamespaces, new ArrayList<MethodBody>());
            Reference<Object> value = new Reference<Object>(null);
            Reference<Object> outAbc = new Reference<Object>(null);
            prop.resolve(true, localData, new Reference<Object>(null), new Reference<Object>(null), new Reference<Integer>(0), value, outAbc);
            boolean resolved = true;
            if (value.getVal() == null) {
                resolved = false;
            }
            if (!resolved) {
                AbcIndexing.TraitIndex ti;
                DottedChain fullCustom = null;
                for (DottedChain imp : importedClasses) {
                    if (!imp.getLast().equals(custom)) continue;
                    fullCustom = imp;
                    break;
                }
                if (fullCustom != null && (ti = abcIndex.findScriptProperty(fullCustom)) != null && ti.trait instanceof TraitSlotConst && ((TraitSlotConst)ti.trait).isNamespace()) {
                    Namespace ns = ti.abc.constants.getNamespace(((TraitSlotConst)ti.trait).value_index);
                    this.nsIndex = abcIndex.getSelectedAbc().constants.getNamespaceId(ns.kind, ns.getName(ti.abc.constants), 0, true);
                    return;
                }
                throw new CompilationException("Namespace \"" + this.name + "\"+not defined", -1);
            }
            this.nsIndex = abcIndex.getSelectedAbc().constants.getNamespaceId(8, ((ABC)outAbc.getVal()).constants.getNamespace(((ValueKind)value.getVal()).value_index).getName(((ABC)outAbc.getVal()).constants), 0, true);
        }
    }

    public boolean isResolved() {
        return this.nsIndex > -1;
    }

    public int getCpoolIndex(AbcIndexing abcIndex) throws CompilationException {
        if (this.nsIndex > -1) {
            return this.nsIndex;
        }
        if (this.kind == 8) {
            throw new CompilationException("Namespace \"" + this.name + "\" unresolved", -1);
        }
        this.nsIndex = abcIndex.getSelectedAbc().constants.getNamespaceId(this.kind, this.name, 0, true);
        return this.nsIndex;
    }

    public static int getCpoolSetIndex(AbcIndexing abcIndex, List<NamespaceItem> namespaces) throws CompilationException {
        int[] nssa = new int[namespaces.size()];
        for (int i = 0; i < nssa.length; ++i) {
            nssa[i] = namespaces.get(i).getCpoolIndex(abcIndex);
        }
        return abcIndex.getSelectedAbc().constants.getNamespaceSetId(nssa, true);
    }
}

