/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.clauses;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetSlotAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;

public class DeclarationAVM2Item
extends AVM2Item {
    public GraphTargetItem assignment;
    public GraphTargetItem type;

    public DeclarationAVM2Item(GraphTargetItem assignment, GraphTargetItem type) {
        super(assignment.getSrc(), assignment.getLineStartItem(), assignment.getPrecedence());
        this.type = type;
        this.assignment = assignment;
    }

    public DeclarationAVM2Item(GraphTargetItem assignment) {
        this(assignment, null);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.assignment instanceof LocalRegAVM2Item) {
            LocalRegAVM2Item lti = (LocalRegAVM2Item)this.assignment;
            String localName = DeclarationAVM2Item.localRegName(localData.localRegNames, lti.regIndex);
            HighlightData srcData = this.getSrcData();
            srcData.localName = localName;
            srcData.declaration = true;
            srcData.regIndex = lti.regIndex;
            srcData.declaredType = DottedChain.ALL;
            writer.append("var ");
            writer.append(localName);
            return writer;
        }
        if (this.assignment instanceof GetSlotAVM2Item) {
            GetSlotAVM2Item sti = (GetSlotAVM2Item)this.assignment;
            HighlightData srcData = this.getSrcData();
            srcData.localName = sti.getNameAsStr(localData);
            srcData.declaration = true;
            srcData.declaredType = DottedChain.ALL;
            writer.append("var ");
            sti.getName(writer, localData);
            return writer;
        }
        if (this.assignment instanceof SetLocalAVM2Item) {
            SetLocalAVM2Item lti = (SetLocalAVM2Item)this.assignment;
            String localName = DeclarationAVM2Item.localRegName(localData.localRegNames, lti.regIndex);
            HighlightData srcData = this.getSrcData();
            srcData.localName = localName;
            srcData.declaration = true;
            srcData.regIndex = lti.regIndex;
            GraphTargetItem val = lti.value;
            GraphTargetItem coerType = TypeItem.UNBOUNDED;
            if (lti.value instanceof CoerceAVM2Item) {
                coerType = ((CoerceAVM2Item)lti.value).typeObj;
            }
            if (lti.value instanceof ConvertAVM2Item) {
                coerType = ((ConvertAVM2Item)lti.value).type;
            }
            if (coerType.equals(this.type) && !coerType.equals(TypeItem.UNBOUNDED)) {
                val = val.value;
            }
            srcData.declaredType = coerType instanceof TypeItem ? ((TypeItem)coerType).fullTypeName : DottedChain.ALL;
            writer.append("var ");
            writer.append(localName);
            writer.append(":");
            this.type.appendTry(writer, localData);
            writer.append(" = ");
            return val.toString(writer, localData);
        }
        if (this.assignment instanceof SetSlotAVM2Item) {
            SetSlotAVM2Item ssti = (SetSlotAVM2Item)this.assignment;
            HighlightData srcData = this.getSrcData();
            srcData.localName = ssti.getNameAsStr(localData);
            srcData.declaration = true;
            GraphTargetItem val = ssti.value;
            GraphTargetItem coerType = TypeItem.UNBOUNDED;
            if (ssti.value instanceof CoerceAVM2Item) {
                coerType = ((CoerceAVM2Item)ssti.value).typeObj;
            }
            if (ssti.value instanceof ConvertAVM2Item) {
                coerType = ((ConvertAVM2Item)ssti.value).type;
            }
            if (coerType.equals(this.type) && !coerType.equals(TypeItem.UNBOUNDED)) {
                val = val.value;
            }
            srcData.declaredType = this.type instanceof TypeItem ? ((TypeItem)this.type).fullTypeName : DottedChain.ALL;
            writer.append("var ");
            ssti.getName(writer, localData);
            writer.append(":");
            this.type.appendTry(writer, localData);
            writer.append(" = ");
            return val.toString(writer, localData);
        }
        writer.append("var ");
        return this.assignment.toString(writer, localData);
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

