/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class NewFunctionAVM2Item
extends AVM2Item {
    public String functionName;
    public String path;
    public boolean isStatic;
    public int scriptIndex;
    public int classIndex;
    public ABC abc;
    public List<DottedChain> fullyQualifiedNames;
    public int methodIndex;

    public NewFunctionAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, String functionName, String path, boolean isStatic, int scriptIndex, int classIndex, ABC abc, List<DottedChain> fullyQualifiedNames, int methodIndex) {
        super(instruction, lineStartIns, 0);
        this.functionName = functionName;
        this.path = path;
        this.isStatic = isStatic;
        this.scriptIndex = scriptIndex;
        this.classIndex = classIndex;
        this.abc = abc;
        this.fullyQualifiedNames = fullyQualifiedNames;
        this.methodIndex = methodIndex;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        MethodBody body = this.abc.findBody(this.methodIndex);
        writer.append("function");
        writer.startMethod(this.methodIndex);
        writer.append(!this.functionName.isEmpty() ? " " + this.functionName : "");
        writer.appendNoHilight("(");
        this.abc.method_info.get(this.methodIndex).getParamStr(writer, this.abc.constants, body, this.abc, this.fullyQualifiedNames);
        writer.appendNoHilight("):");
        if (Configuration.showMethodBodyId.get().booleanValue()) {
            writer.appendNoHilight("// method body index: ");
            writer.appendNoHilight(this.abc.findBodyIndex(this.methodIndex));
            writer.appendNoHilight(" method index: ");
            writer.appendNoHilight(this.methodIndex);
            writer.newLine();
        }
        this.abc.method_info.get(this.methodIndex).getReturnTypeStr(writer, this.abc.constants, this.fullyQualifiedNames);
        writer.startBlock();
        if (body != null) {
            body.convert(new ConvertData(), this.path + "/inner", ScriptExportMode.AS, this.isStatic, this.methodIndex, this.scriptIndex, this.classIndex, this.abc, null, new ScopeStack(), 0, new NulWriter(), this.fullyQualifiedNames, null, false);
            body.toString(this.path + "/inner", ScriptExportMode.AS, this.abc, null, writer, this.fullyQualifiedNames);
        }
        writer.endBlock();
        writer.endMethod();
        return writer;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(DottedChain.FUNCTION);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

